/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hazelcast.micrometer;

import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.MigrationState;
import com.hazelcast.partition.ReplicaMigrationEvent;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collections;
import java.util.List;

final class MigrationMetricsListener
implements MigrationListener {
    private static final String METER_PREFIX = "hazelcast.migration.";
    private final MeterRegistry meterRegistry;

    MigrationMetricsListener(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void migrationStarted(MigrationState state) {
    }

    public void migrationFinished(MigrationState state) {
    }

    public void replicaMigrationCompleted(ReplicaMigrationEvent event) {
        this.incrementCounter("completed", this.tags(event));
    }

    public void replicaMigrationFailed(ReplicaMigrationEvent event) {
        this.incrementCounter("failed", this.tags(event));
    }

    private void incrementCounter(String meterName, Iterable<Tag> tags) {
        this.meterRegistry.counter(METER_PREFIX + meterName, tags).increment();
    }

    private List<Tag> tags(ReplicaMigrationEvent event) {
        return Collections.singletonList(Tag.of((String)"partitionId", (String)String.valueOf(event.getPartitionId())));
    }
}

