/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hazelcast.micrometer;

import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import java.util.Collection;

final class MessageMetricsListener<T>
implements MessageListener<T> {
    private static final String METER_PREFIX = "hazelcast.topic.";
    private final MeterRegistry meterRegistry;

    MessageMetricsListener(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void onMessage(Message event) {
        this.meterRegistry.counter("hazelcast.topic.messageReceived", this.tags(event));
    }

    private Collection<Tag> tags(Message event) {
        return Arrays.asList(Tag.of((String)"source", (String)String.valueOf(event.getSource())), Tag.of((String)"publishingMember", (String)String.valueOf(event.getPublishingMember().getAddress())));
    }
}

