/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hazelcast.micrometer;

import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import java.util.Collection;

final class ItemMetricsListener<T>
implements ItemListener<T> {
    private static final String METER_PREFIX = "hazelcast.collection.";
    private final MeterRegistry meterRegistry;

    ItemMetricsListener(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void itemAdded(ItemEvent event) {
        this.meterRegistry.counter("hazelcast.collection.itemAdded", this.tags(event));
    }

    public void itemRemoved(ItemEvent event) {
        this.meterRegistry.counter("hazelcast.collection.itemRemoved", this.tags(event));
    }

    private Collection<Tag> tags(ItemEvent event) {
        return Arrays.asList(Tag.of((String)"source", (String)String.valueOf(event.getSource())));
    }
}

