/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hamcrest;

import com.atlassian.hamcrest.Arrays;
import com.atlassian.hamcrest.Functions;
import com.atlassian.hamcrest.MatcherFactory;
import com.atlassian.hamcrest.Predicates;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectivelyEqual<T>
extends DiagnosingMatcher<T> {
    private final Iterable<FieldMatcher> fieldMatchers;

    public ReflectivelyEqual(T expected, MatcherFactory baseMatcherFactory) {
        this.fieldMatchers = Iterables.transform(this.matchableFieldsOf(expected.getClass()), Functions.cache(this.toValueMatchers(expected, baseMatcherFactory)));
    }

    protected boolean matches(Object actual, Description mismatchDescription) {
        if (actual == null) {
            mismatchDescription.appendValue(null);
            return false;
        }
        boolean mismatchFound = false;
        for (FieldMatcher fieldMatcher : this.fieldMatchers) {
            Matcher<?> matcher = fieldMatcher.matcher;
            Field field = fieldMatcher.field;
            Object actualFieldValue = ReflectivelyEqual.get(field, actual);
            if (matcher.matches(actualFieldValue)) continue;
            if (!mismatchFound) {
                mismatchDescription.appendText("{");
                mismatchFound = true;
            } else {
                mismatchDescription.appendText(", ");
            }
            mismatchDescription.appendText(field.getName()).appendText(" ");
            matcher.describeMismatch(actualFieldValue, mismatchDescription);
        }
        if (mismatchFound) {
            mismatchDescription.appendText("}");
        }
        return !mismatchFound;
    }

    public void describeTo(Description desc) {
        desc.appendText("{");
        Iterator<FieldMatcher> it = this.fieldMatchers.iterator();
        while (it.hasNext()) {
            FieldMatcher fieldMatcher = it.next();
            desc.appendText(fieldMatcher.field.getName()).appendText(" ").appendDescriptionOf(fieldMatcher.matcher);
            if (!it.hasNext()) continue;
            desc.appendText(", ");
        }
        desc.appendText("}");
    }

    private Iterable<Field> matchableFieldsOf(Class<?> cls) {
        if (cls == null) {
            return ImmutableList.of();
        }
        AccessibleObject[] fields = cls.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        return Iterables.concat(this.matchableFieldsOf(cls.getSuperclass()), (Iterable)Iterables.filter(Arrays.asList(fields), (Predicate)com.google.common.base.Predicates.not((Predicate)com.google.common.base.Predicates.or(Predicates.isTransient(), Predicates.isStatic()))));
    }

    private Function<Field, FieldMatcher> toValueMatchers(final T expected, final MatcherFactory matcherFactory) {
        return new Function<Field, FieldMatcher>(){

            public FieldMatcher apply(Field f) {
                return new FieldMatcher(f, matcherFactory.newEqualMatcher(ReflectivelyEqual.get(f, expected), matcherFactory));
            }
        };
    }

    private static Object get(Field field, Object actual) throws InternalError {
        try {
            return field.get(actual);
        }
        catch (IllegalAccessException e) {
            throw new InternalError("Unexpected IllegalAccessException");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldMatcher {
        final Field field;
        final Matcher<?> matcher;

        FieldMatcher(Field field, Matcher<?> matcher) {
            this.field = field;
            this.matcher = matcher;
        }
    }
}

