/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hamcrest;

import com.atlassian.hamcrest.MatcherFactory;
import com.atlassian.hamcrest.ReflectiveEqualFactory;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReflectiveObjectMatcherFactory
implements MatcherFactory {
    private final MatcherFactory fallbackFactory = new ReflectiveEqualFactory();
    private final Iterable<Map<Matcher<Class<?>>, MatcherFactory>> fieldMatcherFactories;

    ReflectiveObjectMatcherFactory(Iterable<Map<Matcher<Class<?>>, MatcherFactory>> fieldMatcherFactories) {
        this.fieldMatcherFactories = fieldMatcherFactories;
    }

    @Override
    public <T> Matcher<? super T> newEqualMatcher(T expected, MatcherFactory baseMatcherFactory) {
        if (expected == null) {
            return Matchers.nullValue();
        }
        for (Map<Matcher<Class<?>>, MatcherFactory> factories : this.fieldMatcherFactories) {
            for (Map.Entry<Matcher<Class<?>>, MatcherFactory> entry : factories.entrySet()) {
                if (!entry.getKey().matches(expected.getClass())) continue;
                return entry.getValue().newEqualMatcher(expected, baseMatcherFactory);
            }
        }
        return this.fallbackFactory.newEqualMatcher(expected, baseMatcherFactory);
    }
}

