/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hamcrest;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Functions {
    Functions() {
    }

    static <F, T> Function<F, T> cache(Function<F, T> f) {
        return new CachingFunction<F, T>(f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CachingFunction<F, T>
    implements Function<F, T> {
        private final ConcurrentMap<F, T> cache = new MapMaker().makeMap();
        private final Function<F, T> function;

        public CachingFunction(Function<F, T> function) {
            this.function = function;
        }

        public T apply(F from) {
            if (this.cache.containsKey(from)) {
                return (T)this.cache.get(from);
            }
            Object computedValue = this.function.apply(from);
            Object cachedValue = this.cache.putIfAbsent(from, computedValue);
            return (T)(cachedValue == null ? computedValue : cachedValue);
        }
    }
}

