/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hamcrest;

import com.atlassian.hamcrest.ArrayEqualFactory;
import com.atlassian.hamcrest.ClassMatchers;
import com.atlassian.hamcrest.MatcherFactories;
import com.atlassian.hamcrest.MatcherFactory;
import com.atlassian.hamcrest.ReflectiveObjectMatcherFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepIsEqual<T>
extends DiagnosingMatcher<T> {
    private final Matcher<?> typeMatcher;
    private final Matcher<? super T> valueMatcher;

    private DeepIsEqual(T expected, MatcherFactory matcherFactory) {
        if (expected == null) {
            this.typeMatcher = Matchers.is((Matcher)Matchers.anything());
            this.valueMatcher = Matchers.nullValue();
        } else {
            this.typeMatcher = Matchers.is((Matcher)Matchers.equalTo(expected.getClass()));
            this.valueMatcher = matcherFactory.newEqualMatcher(expected, matcherFactory);
        }
    }

    protected boolean matches(Object actual, Description mismatchDescription) {
        if (actual != null && !this.typeMatcher.matches(actual.getClass())) {
            this.typeMatcher.describeMismatch(actual.getClass(), mismatchDescription);
            return false;
        }
        if (!this.valueMatcher.matches(actual)) {
            this.valueMatcher.describeMismatch(actual, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        this.valueMatcher.describeTo(description);
    }

    @Factory
    public static <T> Matcher<? super T> deeplyEqualTo(T operand) {
        return DeepIsEqual.deeplyEqualTo(operand, ImmutableMap.of());
    }

    @Factory
    public static <T> Matcher<? super T> deeplyEqualTo(T operand, Map<Matcher<Class<?>>, MatcherFactory> extraMatcherFactories) {
        return new DeepIsEqual<T>(operand, new ReflectiveObjectMatcherFactory((Iterable<Map<Matcher<Class<?>>, MatcherFactory>>)ImmutableList.of(extraMatcherFactories, (Object)Primitives.FACTORIES)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Primitives {
        private static final Map<Matcher<Class<?>>, MatcherFactory> FACTORIES = Collections.unmodifiableMap(new HashMap<Matcher<Class<?>>, MatcherFactory>(){
            {
                this.put(Primitives.equalTo(Boolean.class), MatcherFactories.isEqual());
                this.put(Primitives.equalTo(Byte.class), MatcherFactories.isEqual());
                this.put(Primitives.equalTo(Short.class), MatcherFactories.isEqual());
                this.put(Primitives.equalTo(Integer.class), MatcherFactories.isEqual());
                this.put(Primitives.equalTo(Long.class), MatcherFactories.isEqual());
                this.put(Primitives.equalTo(Float.class), MatcherFactories.isEqual());
                this.put(Primitives.equalTo(Double.class), MatcherFactories.isEqual());
                this.put(Primitives.equalTo(Character.class), MatcherFactories.isEqual());
                this.put(Primitives.equalTo(String.class), MatcherFactories.isEqual());
                this.put(ClassMatchers.isArray(), new ArrayEqualFactory());
            }
        });

        private Primitives() {
        }

        private static Matcher<Class<?>> equalTo(Class<?> c) {
            return Matchers.equalTo(c);
        }
    }
}

