/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hamcrest;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassMatchers {
    private static final Matcher<Class<?>> IS_ARRAY = new IsArray();

    public static Matcher<Class<?>> isArray() {
        return IS_ARRAY;
    }

    public static final Matcher<Class<?>> isAssignableTo(Class<?> to) {
        return new IsAssignableTo(to);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IsAssignableTo
    extends TypeSafeMatcher<Class<?>> {
        private final Class<?> to;

        public IsAssignableTo(Class<?> to) {
            this.to = to;
        }

        protected boolean matchesSafely(Class<?> c) {
            return this.to.isAssignableFrom(c);
        }

        public void describeTo(Description description) {
            description.appendText("is assignable to ").appendValue(this.to);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IsArray
    extends TypeSafeMatcher<Class<?>> {
        private IsArray() {
        }

        protected boolean matchesSafely(Class<?> c) {
            return c.isArray();
        }

        public void describeTo(Description description) {
            description.appendText("is an array");
        }
    }
}

