/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hamcrest;

import com.atlassian.hamcrest.ArrayDeepIsEqualMatcher;
import com.atlassian.hamcrest.Arrays;
import com.atlassian.hamcrest.MatcherFactory;
import java.util.List;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayEqualFactory
implements MatcherFactory {
    ArrayEqualFactory() {
    }

    @Override
    public <T> Matcher<? super T> newEqualMatcher(T expected, MatcherFactory baseMatcherFactory) {
        List<Object> elements;
        Class<?> elementType = expected.getClass().getComponentType();
        if (!elementType.isPrimitive()) {
            elements = java.util.Arrays.asList((Object[])expected);
        } else if (Boolean.TYPE.equals(elementType)) {
            elements = Arrays.asList((boolean[])expected);
        } else if (Byte.TYPE.equals(elementType)) {
            elements = Arrays.asList((byte[])expected);
        } else if (Short.TYPE.equals(elementType)) {
            elements = Arrays.asList((short[])expected);
        } else if (Integer.TYPE.equals(elementType)) {
            elements = Arrays.asList((int[])expected);
        } else if (Long.TYPE.equals(elementType)) {
            elements = Arrays.asList((long[])expected);
        } else if (Float.TYPE.equals(elementType)) {
            elements = Arrays.asList((float[])expected);
        } else if (Double.TYPE.equals(elementType)) {
            elements = Arrays.asList((double[])expected);
        } else if (Character.TYPE.equals(elementType)) {
            elements = Arrays.asList((char[])expected);
        } else {
            throw new InternalError("Umm... did you add a new primitive type to Java or something?");
        }
        return new ArrayDeepIsEqualMatcher(elements, baseMatcherFactory);
    }
}

