/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hamcrest;

import com.atlassian.hamcrest.Functions;
import com.atlassian.hamcrest.MatcherFactory;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayDeepIsEqualMatcher<T>
extends DiagnosingMatcher<T> {
    private final int expectedSize;
    private final Iterable<Matcher<?>> matchers;

    public ArrayDeepIsEqualMatcher(Iterable<?> expected, MatcherFactory baseMatcherFactory) {
        this.expectedSize = Iterables.size(expected);
        this.matchers = Iterables.transform(expected, Functions.cache(this.toMatchers(baseMatcherFactory)));
    }

    private Function<Object, Matcher<?>> toMatchers(final MatcherFactory matcherFactory) {
        return new Function<Object, Matcher<?>>(){

            public Matcher<?> apply(Object element) {
                return matcherFactory.newEqualMatcher(element, matcherFactory);
            }
        };
    }

    protected boolean matches(Object actual, Description mismatchDescription) {
        if (this.expectedSize != Array.getLength(actual)) {
            this.describeTo(mismatchDescription);
            return false;
        }
        boolean mismatchFound = false;
        int index = 0;
        for (Matcher<?> matcher : this.matchers) {
            Object element;
            if (matcher.matches(element = Array.get(actual, index))) {
                ++index;
                continue;
            }
            if (!mismatchFound) {
                mismatchDescription.appendText("[");
                mismatchFound = true;
            } else {
                mismatchDescription.appendText(", ");
            }
            mismatchDescription.appendText("[").appendValue((Object)index).appendText("] => ");
            matcher.describeMismatch(element, mismatchDescription);
            ++index;
        }
        if (mismatchFound) {
            mismatchDescription.appendText("]");
        }
        return !mismatchFound;
    }

    public void describeTo(Description desc) {
        desc.appendText("[");
        int index = 0;
        for (Matcher<?> matcher : this.matchers) {
            if (index > 0) {
                desc.appendText(", ");
            }
            desc.appendText("[").appendValue((Object)index).appendText("] => ").appendDescriptionOf(matcher);
            ++index;
        }
    }
}

