/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.h2;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.h2.ServerLifecycle;
import com.atlassian.h2.ServerView;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.h2.tools.Server;

@ThreadSafe
public class DatabaseCreatingServerLifecycle
extends ServerLifecycle {
    private final Supplier<File> databaseDirectory;
    private final String databaseName;

    public DatabaseCreatingServerLifecycle(@Nonnull Supplier<Server> serverFactory, @Nonnull Supplier<File> databaseDirectory, @Nonnull String databaseName) {
        super(serverFactory);
        this.databaseDirectory = Objects.requireNonNull(databaseDirectory);
        this.databaseName = Objects.requireNonNull(databaseName);
    }

    @Override
    @Nonnull
    public synchronized ServerView start() {
        ServerView view = this.view();
        if (!view.isRunning()) {
            DatabaseDetails details;
            view = super.start();
            String dbName = new File(this.databaseDirectory.get(), this.databaseName).getAbsolutePath();
            try {
                details = DatabaseDetails.getDefaults((String)"h2");
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Cannot load database defaults", e);
            }
            try (Connection connection = DriverManager.getConnection("jdbc:h2:" + dbName, details.getUserName(), details.getPassword());
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("select 1");){
                resultSet.next();
            }
            catch (SQLException e) {
                throw new RuntimeException("Cannot connect to " + this.databaseName, e);
            }
        }
        return view;
    }
}

