/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.h2;

import com.atlassian.h2.ServerView;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import javax.annotation.concurrent.ThreadSafe;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ServerLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ServerLifecycle.class);
    private final Supplier<Server> server;
    private final Supplier<ServerView> serverView = new LazyReference<ServerView>(){

        protected ServerView create() throws Exception {
            return new ServerView(){

                @Override
                public boolean isRunning() {
                    return ((Server)ServerLifecycle.this.server.get()).isRunning(false);
                }

                @Override
                public URI getUri() {
                    try {
                        return new URI("jdbc:h2:tcp://localhost:" + ((Server)ServerLifecycle.this.server.get()).getPort());
                    }
                    catch (URISyntaxException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }

                public String toString() {
                    return ServerLifecycle.this.server.toString();
                }
            };
        }
    };

    public ServerLifecycle(final Supplier<Server> serverFactory) {
        this.server = new LazyReference<Server>(){

            protected Server create() throws Exception {
                return (Server)serverFactory.get();
            }
        };
    }

    public ServerView view() {
        return (ServerView)this.serverView.get();
    }

    public synchronized ServerView start() {
        ServerView view = this.view();
        if (!view.isRunning()) {
            try {
                ((Server)this.server.get()).start();
            }
            catch (SQLException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return this.view();
    }

    public synchronized ServerView stop() {
        ServerView view = this.view();
        if (view.isRunning()) {
            ((Server)this.server.get()).stop();
        }
        return this.view();
    }
}

