/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.git.tripper;

import com.atlassian.git.tripper.Status;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableStatus
extends Status {
    private final ImmutableSet<String> fullyStaged;
    private final ImmutableSet<String> notStaged;
    private final ImmutableSet<String> partiallyStaged;
    private final ImmutableSet<String> staged;

    private ImmutableStatus(ImmutableSet<String> fullyStaged, ImmutableSet<String> notStaged, ImmutableSet<String> partiallyStaged, ImmutableSet<String> staged) {
        this.fullyStaged = fullyStaged;
        this.notStaged = notStaged;
        this.partiallyStaged = partiallyStaged;
        this.staged = staged;
    }

    public ImmutableSet<String> fullyStaged() {
        return this.fullyStaged;
    }

    public ImmutableSet<String> notStaged() {
        return this.notStaged;
    }

    public ImmutableSet<String> partiallyStaged() {
        return this.partiallyStaged;
    }

    public ImmutableSet<String> staged() {
        return this.staged;
    }

    public final ImmutableStatus withFullyStaged(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableStatus((ImmutableSet<String>)newValue, this.notStaged, this.partiallyStaged, this.staged);
    }

    public final ImmutableStatus withFullyStaged(Iterable<String> elements) {
        if (this.fullyStaged == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableStatus((ImmutableSet<String>)newValue, this.notStaged, this.partiallyStaged, this.staged);
    }

    public final ImmutableStatus withNotStaged(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableStatus(this.fullyStaged, (ImmutableSet<String>)newValue, this.partiallyStaged, this.staged);
    }

    public final ImmutableStatus withNotStaged(Iterable<String> elements) {
        if (this.notStaged == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableStatus(this.fullyStaged, (ImmutableSet<String>)newValue, this.partiallyStaged, this.staged);
    }

    public final ImmutableStatus withPartiallyStaged(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableStatus(this.fullyStaged, this.notStaged, (ImmutableSet<String>)newValue, this.staged);
    }

    public final ImmutableStatus withPartiallyStaged(Iterable<String> elements) {
        if (this.partiallyStaged == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableStatus(this.fullyStaged, this.notStaged, (ImmutableSet<String>)newValue, this.staged);
    }

    public final ImmutableStatus withStaged(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableStatus(this.fullyStaged, this.notStaged, this.partiallyStaged, (ImmutableSet<String>)newValue);
    }

    public final ImmutableStatus withStaged(Iterable<String> elements) {
        if (this.staged == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableStatus(this.fullyStaged, this.notStaged, this.partiallyStaged, (ImmutableSet<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatus && this.equalTo((ImmutableStatus)another);
    }

    private boolean equalTo(ImmutableStatus another) {
        return this.fullyStaged.equals(another.fullyStaged) && this.notStaged.equals(another.notStaged) && this.partiallyStaged.equals(another.partiallyStaged) && this.staged.equals(another.staged);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fullyStaged.hashCode();
        h += (h << 5) + this.notStaged.hashCode();
        h += (h << 5) + this.partiallyStaged.hashCode();
        h += (h << 5) + this.staged.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Status").omitNullValues().add("fullyStaged", this.fullyStaged).add("notStaged", this.notStaged).add("partiallyStaged", this.partiallyStaged).add("staged", this.staged).toString();
    }

    public static ImmutableStatus copyOf(Status instance) {
        if (instance instanceof ImmutableStatus) {
            return (ImmutableStatus)instance;
        }
        return ImmutableStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableSet.Builder<String> fullyStaged = ImmutableSet.builder();
        private ImmutableSet.Builder<String> notStaged = ImmutableSet.builder();
        private ImmutableSet.Builder<String> partiallyStaged = ImmutableSet.builder();
        private ImmutableSet.Builder<String> staged = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Status instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllFullyStaged(instance.fullyStaged());
            this.addAllNotStaged(instance.notStaged());
            this.addAllPartiallyStaged(instance.partiallyStaged());
            this.addAllStaged(instance.staged());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFullyStaged(String element) {
            this.fullyStaged.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFullyStaged(String ... elements) {
            this.fullyStaged.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fullyStaged(Iterable<String> elements) {
            this.fullyStaged = ImmutableSet.builder();
            return this.addAllFullyStaged(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFullyStaged(Iterable<String> elements) {
            this.fullyStaged.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNotStaged(String element) {
            this.notStaged.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNotStaged(String ... elements) {
            this.notStaged.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder notStaged(Iterable<String> elements) {
            this.notStaged = ImmutableSet.builder();
            return this.addAllNotStaged(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNotStaged(Iterable<String> elements) {
            this.notStaged.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPartiallyStaged(String element) {
            this.partiallyStaged.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPartiallyStaged(String ... elements) {
            this.partiallyStaged.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partiallyStaged(Iterable<String> elements) {
            this.partiallyStaged = ImmutableSet.builder();
            return this.addAllPartiallyStaged(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPartiallyStaged(Iterable<String> elements) {
            this.partiallyStaged.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStaged(String element) {
            this.staged.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStaged(String ... elements) {
            this.staged.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder staged(Iterable<String> elements) {
            this.staged = ImmutableSet.builder();
            return this.addAllStaged(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStaged(Iterable<String> elements) {
            this.staged.addAll(elements);
            return this;
        }

        public ImmutableStatus build() {
            return new ImmutableStatus(this.fullyStaged.build(), this.notStaged.build(), this.partiallyStaged.build(), this.staged.build());
        }
    }
}

