/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.git.tripper;

import com.atlassian.git.tripper.Commit;
import com.atlassian.git.tripper.Git;
import com.atlassian.git.tripper.GitLogFormatPlaceholder;
import com.atlassian.git.tripper.GitPathStatus;
import com.atlassian.git.tripper.ImmutableCommit;
import com.atlassian.git.tripper.ImmutableGitLogFormatString;
import com.atlassian.git.tripper.ImmutableStatus;
import com.atlassian.git.tripper.Status;
import com.atlassian.git.tripper.internal.proc.Process;
import com.atlassian.git.tripper.internal.proc.ProcessBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class GitSubprocess
implements Git {
    private final String workdir;
    private final Supplier<ProcessBuilder> newProcessBuilder;
    private static final String ARROW_SEPERATOR = " -> ";

    public GitSubprocess(String workdir) {
        this.workdir = workdir;
        this.newProcessBuilder = ProcessBuilder::New;
    }

    protected GitSubprocess(String workdir, Supplier<ProcessBuilder> newProcessBuilder) {
        this.workdir = workdir;
        this.newProcessBuilder = newProcessBuilder;
    }

    @Override
    public Status status() throws UncheckedIOException {
        List<String> lines = this.invokeGit("status", "--porcelain");
        List statuses = lines.stream().map(GitPathStatus::fromString).collect(Collectors.toList());
        return ImmutableStatus.builder().addAllFullyStaged(statuses.stream().filter(GitPathStatus::isFullyStaged).map(GitPathStatus::getPath).collect(Collectors.toList())).addAllPartiallyStaged(statuses.stream().filter(GitPathStatus::isPartiallyStaged).map(GitPathStatus::getPath).collect(Collectors.toList())).addAllNotStaged(statuses.stream().filter(p -> !p.isFullyStaged() && !p.isPartiallyStaged()).map(GitPathStatus::getPath).collect(Collectors.toList())).build();
    }

    @Override
    public void add(Set<String> targets) throws UncheckedIOException {
        ArrayList args = Lists.newArrayList();
        args.add("add");
        targets.forEach(args::add);
        this.invokeGit(args);
    }

    @Override
    public File adminDir() throws UncheckedIOException {
        ImmutableList args = ImmutableList.of((Object)"rev-parse", (Object)"--git-dir");
        return new File(this.procWithSingleLineOutput((List<String>)args));
    }

    @Override
    public File globalAdminDir() throws UncheckedIOException {
        ImmutableList args = ImmutableList.of((Object)"rev-parse", (Object)"--git-common-dir");
        return new File(this.procWithSingleLineOutput((List<String>)args));
    }

    @Override
    public String localBranch() throws UncheckedIOException {
        ImmutableList args = ImmutableList.of((Object)"rev-parse", (Object)"--abbrev-ref", (Object)"HEAD");
        return this.procWithSingleLineOutput((List<String>)args);
    }

    @Override
    public Optional<String> remoteBranch() throws UncheckedIOException {
        ImmutableList args = ImmutableList.of((Object)"rev-parse", (Object)"--abbrev-ref", (Object)"--symbolic-full-name", (Object)"@{u}");
        return this.procWithOptionalLineOutput((List<String>)args);
    }

    @Override
    public boolean currentlyMerging() throws UncheckedIOException {
        File dotGit = this.adminDir();
        File mergeHead = new File(dotGit.getAbsolutePath() + "/MERGE_HEAD");
        return mergeHead.exists();
    }

    @Override
    public void addAll() throws UncheckedIOException {
        ImmutableList args = ImmutableList.of((Object)"add", (Object)"-A");
        this.invokeGit((List<String>)args);
    }

    @Override
    public void commit(String msg) throws UncheckedIOException {
        ImmutableList args = ImmutableList.of((Object)"commit", (Object)"-m", (Object)msg);
        this.invokeGit((List<String>)args);
    }

    @Override
    public void push() throws UncheckedIOException {
        ImmutableList args = ImmutableList.of((Object)"push");
        this.invokeGit((List<String>)args);
    }

    @Override
    public void push(String remote, String branch) throws UncheckedIOException {
        ImmutableList args = ImmutableList.of((Object)"push", (Object)remote, (Object)branch);
        this.invokeGit((List<String>)args);
    }

    @Override
    public Commit mergeBase(List<String> commits) {
        List<String> lines = this.invokeGit((List<String>)ImmutableList.builder().add((Object)"merge-base").addAll(commits).build());
        String hash = lines.get(0);
        return this.getCommit(hash);
    }

    public Commit getCommit(String hash) throws UncheckedIOException {
        ImmutableList placeholders = ImmutableList.of((Object)((Object)GitLogFormatPlaceholder.COMMIT_HASH), (Object)((Object)GitLogFormatPlaceholder.COMMITTER_DATE_UNIX_TIMESTAMP));
        ImmutableGitLogFormatString logFormat = ImmutableGitLogFormatString.builder().delimiter(GitLogFormatPlaceholder.NEWLINE.toString()).addAllPlaceholders((Iterable<? extends GitLogFormatPlaceholder>)placeholders).build();
        List<String> lines = this.invokeGit("show", "--no-patch", "--format=" + logFormat, hash);
        if (lines.size() != placeholders.size()) {
            throw new RuntimeException("`git show` did not return " + placeholders.size() + " lines:\n" + String.join((CharSequence)"\n", lines));
        }
        return ImmutableCommit.builder().hash(lines.get(0)).commitTime(Instant.ofEpochSecond(Integer.parseInt(lines.get(1)))).build();
    }

    @Override
    public Commit revParse(String revision) {
        List<String> lines = this.invokeGit("rev-parse", "--verify", revision);
        return this.getCommit(lines.get(0));
    }

    private Optional<String> procWithOptionalLineOutput(List<String> args) throws UncheckedIOException {
        return this.invokeGit(args).stream().findFirst();
    }

    private String procWithSingleLineOutput(List<String> args) throws UncheckedIOException {
        return this.procWithOptionalLineOutput(args).get();
    }

    protected List<String> invokeGit(List<String> arguments) throws UncheckedIOException {
        ImmutableList gitCommand = ImmutableList.builder().add((Object)"git").addAll(arguments).build();
        try {
            Process p = this.proc().command((List<String>)gitCommand).start();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)baos);
            int returnCode = p.waitFor();
            if (returnCode != 0) {
                throw new IOException(new String(baos.toByteArray(), StandardCharsets.UTF_8));
            }
            return IOUtils.readLines((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Charset)StandardCharsets.UTF_8);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted.");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected List<String> invokeGit(String ... arguments) throws UncheckedIOException {
        return this.invokeGit(Arrays.asList(arguments));
    }

    private ProcessBuilder proc() {
        return this.newProcessBuilder.get().directory(new File(this.workdir)).redirectErrorStream(true);
    }

    @Override
    public void close() throws Exception {
    }
}

