/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.git.tripper;

import java.util.Arrays;

public enum GitStatusCode {
    UNMODIFIED(' '),
    MODIFIED('M'),
    ADDED('A'),
    DELETED('D'),
    RENAMED('R'),
    COPIED('C'),
    UPDATED_BUT_UNMERGED('U'),
    UNTRACKED('?');

    private final char code;

    private GitStatusCode(char code) {
        this.code = code;
    }

    public String toString() {
        return String.valueOf(this.code);
    }

    public static GitStatusCode fromChar(char code) {
        return Arrays.stream(GitStatusCode.values()).filter(status -> status.code == code).findFirst().orElseThrow(() -> new IllegalArgumentException("Code '" + code + "' is not a valid git status code."));
    }
}

