/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.git.tripper;

import com.atlassian.git.tripper.GitStatusCode;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;

public class GitPathStatus {
    private final GitStatusCode indexStatus;
    private final GitStatusCode workTreeStatus;
    private final String path;
    private final Optional<String> renamedPath;

    public GitPathStatus(GitStatusCode indexStatus, GitStatusCode workTreeStatus, String path, Optional<String> renamedPath) {
        this.indexStatus = indexStatus;
        this.workTreeStatus = workTreeStatus;
        this.path = path;
        this.renamedPath = renamedPath;
    }

    public boolean isFullyStaged() {
        return this.indexStatus != GitStatusCode.UNMODIFIED && this.workTreeStatus == GitStatusCode.UNMODIFIED;
    }

    public boolean isPartiallyStaged() {
        return this.indexStatus != GitStatusCode.UNMODIFIED && this.workTreeStatus != GitStatusCode.UNMODIFIED && this.workTreeStatus != GitStatusCode.UNTRACKED;
    }

    public String getPath() {
        return this.renamedPath.orElse(this.path);
    }

    public static GitPathStatus fromString(String line) {
        if (line.length() < 4) {
            throw new IllegalArgumentException("Line '" + line + "' is expected to have format 'XY PATH1 [-> PATH2]'");
        }
        String codes = line.substring(0, 2);
        GitStatusCode indexStatus = GitStatusCode.fromChar(codes.charAt(0));
        GitStatusCode workTreeStatus = GitStatusCode.fromChar(codes.charAt(1));
        List paths = Splitter.on((char)' ').splitToList((CharSequence)line.substring(3));
        if (paths.size() == 1) {
            String path = (String)paths.get(0);
            return new GitPathStatus(indexStatus, workTreeStatus, path, Optional.empty());
        }
        if (paths.size() == 3) {
            String path = (String)paths.get(0);
            String renamedPath = (String)paths.get(2);
            return new GitPathStatus(indexStatus, workTreeStatus, path, Optional.of(renamedPath));
        }
        throw new RuntimeException("git status --porcelain produced '" + line + "' which has an invalid number of parts to it.");
    }
}

