/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UriTemplate {
    private String[] uriTemplateComponents;

    public UriTemplate(String uriTemplate) {
        this.uriTemplateComponents = uriTemplate.split("/");
    }

    public boolean matches(String uri) {
        String[] uriComponents = uri.split("/");
        if (this.uriTemplateComponents.length != uriComponents.length) {
            return false;
        }
        for (int i = 0; i < this.uriTemplateComponents.length; ++i) {
            if (this.isTemplateVariable(this.uriTemplateComponents[i]) || this.uriTemplateComponents[i].equals(uriComponents[i])) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> extractParameters(String uri) {
        if (!this.matches(uri)) {
            throw new IllegalArgumentException(uri + " is not a match for the URI template " + StringUtils.join((Object[])this.uriTemplateComponents, (char)'/'));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        String[] uriComponents = uri.split("/");
        for (int i = 0; i < this.uriTemplateComponents.length; ++i) {
            if (!this.isTemplateVariable(this.uriTemplateComponents[i])) continue;
            parameters.put(this.getTemplateVariableName(this.uriTemplateComponents[i]), uriComponents[i]);
        }
        return Collections.unmodifiableMap(parameters);
    }

    private boolean isTemplateVariable(String s) {
        return s.startsWith("{") && s.endsWith("}");
    }

    private String getTemplateVariableName(String s) {
        return s.substring(1, s.length() - 1);
    }
}

