/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebLink;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebItemFinder {
    public static final String DASHBOARD_MENU_SECTION = "gadgets.dashboard.menu";
    public static final String DASHBOARD_TOOLS_MENU_SECTION = "gadgets.dashboard.tools.menu";
    private final WebInterfaceManager webInterfaceManager;
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18n;

    public WebItemFinder(WebInterfaceManager webInterfaceManager, ApplicationProperties applicationProperties, I18nResolver i18n) {
        this.webInterfaceManager = webInterfaceManager;
        this.applicationProperties = applicationProperties;
        this.i18n = i18n;
    }

    public Iterable<WebItem> findMenuItemsInSection(String section, Map<String, ?> initialContext) {
        ImmutableMap context = ImmutableMap.builder().putAll(initialContext).put((Object)"i18n", (Object)this.i18n).build();
        List descriptors = this.webInterfaceManager.getDisplayableItems(section, (Map)context);
        return Iterables.transform((Iterable)descriptors, (Function)new Function<WebItemModuleDescriptor, WebItem>((Map)context){
            final /* synthetic */ Map val$context;
            {
                this.val$context = map;
            }

            public WebItem apply(WebItemModuleDescriptor descriptor) {
                return new WebItem(descriptor, this.val$context);
            }
        });
    }

    public class GadgetWebLabel {
        private final WebLabel webLabel;
        private final Map<String, Object> context;

        public GadgetWebLabel(WebLabel webLabel, Map<String, Object> context) {
            this.webLabel = webLabel;
            this.context = context;
        }

        public String getDisplayableLabel() {
            return this.webLabel.getDisplayableLabel(null, new HashMap<String, Object>(this.context));
        }
    }

    public class GadgetWebLink {
        private final Map<String, Object> context;
        private final WebLink link;

        public GadgetWebLink(WebLink link, Map<String, Object> context) {
            this.link = link;
            this.context = ImmutableMap.builder().putAll(context).put((Object)"hash", (Object)"#").build();
        }

        public String getId() {
            return this.link.getId();
        }

        public String getDisplayableUrl() {
            String url = this.link.getRenderedUrl(new HashMap<String, Object>(this.context));
            if (this.isRelative(url)) {
                url = WebItemFinder.this.applicationProperties.getBaseUrl() + url;
            }
            return url;
        }

        private boolean isRelative(String url) {
            return !url.startsWith("http://") && !url.startsWith("https://");
        }
    }

    public class WebItem {
        private final WebItemModuleDescriptor descriptor;
        private final Map<String, Object> context;

        public WebItem(WebItemModuleDescriptor descriptor, Map<String, Object> context) {
            this.descriptor = descriptor;
            this.context = context;
        }

        public GadgetWebLink getLink() {
            return new GadgetWebLink(this.descriptor.getLink(), this.context);
        }

        public GadgetWebLabel getLabel() {
            return new GadgetWebLabel(this.descriptor.getWebLabel(), this.context);
        }

        public String getStyleClass() {
            return this.descriptor.getStyleClass();
        }
    }
}

