/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import com.atlassian.gadgets.GadgetSpecUriNotAllowedException;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public class Uri {
    private Uri() {
        throw new AssertionError((Object)"noninstantiable");
    }

    public static String decodeUriComponent(String uriComponent) {
        try {
            return URLDecoder.decode(uriComponent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("JREs are required to support UTF-8");
        }
    }

    public static String encodeUriComponent(String uriComponent) {
        try {
            return URLEncoder.encode(uriComponent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("JREs are required to support UTF-8");
        }
    }

    public static boolean isValid(String gadgetUri) {
        if (StringUtils.isBlank((String)gadgetUri)) {
            return false;
        }
        try {
            URI uri = new URI(gadgetUri).normalize();
            if (uri.isAbsolute() && !"http".equalsIgnoreCase(uri.getScheme()) && !"https".equalsIgnoreCase(uri.getScheme())) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public static URI create(String gadgetUri) throws GadgetSpecUriNotAllowedException {
        if (!Uri.isValid(gadgetUri)) {
            throw new GadgetSpecUriNotAllowedException("gadget spec url must be a valid url beginning with either http: or https:");
        }
        return URI.create(gadgetUri);
    }

    public static String ensureTrailingSlash(String url) {
        return url.endsWith("/") ? url : url + "/";
    }

    public static URI resolveUriAgainstBase(String baseUrl, URI possiblyRelativeUri) {
        Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
        Preconditions.checkNotNull((Object)possiblyRelativeUri, (Object)"possiblyRelativeUri");
        return possiblyRelativeUri.isAbsolute() ? possiblyRelativeUri : URI.create(Uri.ensureTrailingSlash(baseUrl)).resolve(possiblyRelativeUri);
    }

    public static URI resolveUriAgainstBase(String baseUrl, String possiblyRelativeUri) {
        return Uri.resolveUriAgainstBase(baseUrl, URI.create(possiblyRelativeUri));
    }

    public static URI relativizeUriAgainstBase(String baseUrl, URI possiblyAbsoluteUri) {
        Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
        Preconditions.checkNotNull((Object)possiblyAbsoluteUri, (Object)"possiblyAbsoluteUri");
        return possiblyAbsoluteUri.isAbsolute() ? URI.create(Uri.ensureTrailingSlash(baseUrl)).relativize(possiblyAbsoluteUri) : possiblyAbsoluteUri;
    }

    public static URI relativizeUriAgainstBase(String baseUrl, String possiblyAbsoluteUri) {
        return Uri.relativizeUriAgainstBase(baseUrl, URI.create(possiblyAbsoluteUri));
    }
}

