/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionRunner {
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public TransactionRunner(@ComponentImport(value="txTemplate") TransactionTemplate transactionTemplate) {
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate, (Object)"transactionTemplate");
    }

    public <T> T execute(Callable<T> c) {
        return (T)this.transactionTemplate.execute(this.newCallback((Callable)Preconditions.checkNotNull(c)));
    }

    public void execute(Runnable r) {
        this.transactionTemplate.execute(this.newCallback((Runnable)Preconditions.checkNotNull((Object)r)));
    }

    private TransactionCallback newCallback(Callable<?> c) {
        return new CallableCallback(c);
    }

    private TransactionCallback newCallback(Runnable r) {
        return new RunnableCallback(r);
    }

    public static final class TransactionException
    extends RuntimeException {
        TransactionException(Throwable e) {
            super(e);
        }
    }

    private final class RunnableCallback
    implements TransactionCallback {
        private final Runnable r;

        public RunnableCallback(Runnable r) {
            this.r = r;
        }

        public Object doInTransaction() {
            this.r.run();
            return null;
        }
    }

    private final class CallableCallback
    implements TransactionCallback {
        private final Callable<?> c;

        public CallableCallback(Callable<?> c) {
            this.c = c;
        }

        public Object doInTransaction() {
            try {
                return this.c.call();
            }
            catch (Exception e) {
                throw new TransactionException(e);
            }
        }
    }
}

