/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.util;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.util.DashboardItemSerializers;
import com.atlassian.gadgets.view.View;
import com.atlassian.plugin.ModuleCompleteKey;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

public class DashboardItemConditionContext {
    private final Option<GadgetId> gadgetId;
    private final Option<DashboardId> dashboardId;
    private final ModuleCompleteKey moduleCompleteKey;
    private final Option<GadgetRequestContext.User> user;
    private final View view;

    private DashboardItemConditionContext(Option<GadgetId> gadgetId, Option<DashboardId> dashboardId, ModuleCompleteKey moduleCompleteKey, Option<GadgetRequestContext.User> user, View view) {
        this.gadgetId = gadgetId;
        this.dashboardId = dashboardId;
        this.moduleCompleteKey = moduleCompleteKey;
        this.user = user;
        this.view = view;
    }

    public static DashboardItemConditionContext forDirectory(ModuleCompleteKey moduleKey, @Nullable GadgetRequestContext.User user) {
        return new DashboardItemConditionContext((Option<GadgetId>)Option.none(), (Option<DashboardId>)Option.none(), moduleKey, (Option<GadgetRequestContext.User>)Option.option((Object)user), View.DIRECTORY);
    }

    public static DashboardItemConditionContext forRendering(GadgetId gadgetId, DashboardId dashboardId, ModuleCompleteKey moduleKey, GadgetRequestContext requestContext) {
        return new DashboardItemConditionContext((Option<GadgetId>)Option.some((Object)gadgetId), (Option<DashboardId>)Option.some((Object)dashboardId), moduleKey, (Option<GadgetRequestContext.User>)requestContext.getUser(), requestContext.getView());
    }

    public Map<String, Object> getSerializedContext() {
        final ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        this.dashboardId.foreach((Effect)new Effect<DashboardId>(){

            public void apply(DashboardId dashboardId) {
                contextBuilder.put((Object)"dashboard", DashboardItemSerializers.serializeDashboard(dashboardId));
            }
        });
        contextBuilder.put((Object)"dashboardItem", this.serializeDashboardItem());
        contextBuilder.put((Object)"view", DashboardItemSerializers.serializeView(this.view));
        if (this.user.isDefined()) {
            contextBuilder.put((Object)"user", DashboardItemSerializers.serializeUser((GadgetRequestContext.User)this.user.get()));
            contextBuilder.put((Object)"username", (Object)((GadgetRequestContext.User)this.user.get()).getUsername());
        }
        return contextBuilder.build();
    }

    private ImmutableMap<String, Object> serializeDashboardItem() {
        ImmutableMap.Builder dashboardItemBuilder = ImmutableMap.builder().put((Object)"pluginKey", (Object)this.moduleCompleteKey.getPluginKey()).put((Object)"moduleKey", (Object)this.moduleCompleteKey.getModuleKey());
        if (this.gadgetId.isDefined()) {
            dashboardItemBuilder.put((Object)"id", (Object)((GadgetId)this.gadgetId.get()).value());
        }
        return dashboardItemBuilder.build();
    }
}

