/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages;

import com.atlassian.webdriver.AtlassianWebDriver;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class GadgetMenu {
    private final String gadgetId;
    @Inject
    private AtlassianWebDriver driver;

    public GadgetMenu(String id) {
        this.gadgetId = id;
    }

    protected By getGadgetMenu() {
        return By.cssSelector((String)("#" + this.gadgetId + "-renderbox " + ".aui-dropdown"));
    }

    protected By getMenuTrigger() {
        return By.cssSelector((String)("#" + this.gadgetId + "-renderbox " + ".aui-dd-trigger"));
    }

    protected By getTitleBar() {
        return By.cssSelector((String)("#" + this.gadgetId + "-renderbox " + ".dashboard-item-title"));
    }

    protected By getContainer() {
        return By.cssSelector((String)("#" + this.gadgetId + "-renderbox " + ".gadget-container"));
    }

    public GadgetMenu open() {
        this.get(this.getTitleBar()).click();
        new Actions(this.driver.getDriver()).moveToElement(this.get(this.getContainer()), -10, -10).moveToElement(this.get(this.getContainer()), 10, 10).build().perform();
        this.driver.waitUntilElementIsVisible(this.getMenuTrigger());
        this.get(this.getMenuTrigger()).click();
        this.driver.waitUntilElementIsVisible(this.getGadgetMenu());
        return this;
    }

    public WebElement get(By selector) {
        return this.driver.findElement(selector);
    }

    public GadgetMenu selectByClassName(String className) {
        this.get(this.getGadgetMenu()).findElement(By.className((String)className)).click();
        return this;
    }

    public GadgetMenu selectByCSSSelector(String css) {
        WebElement element = this.get(this.getGadgetMenu()).findElement(By.cssSelector((String)css));
        element.click();
        return this;
    }
}

