/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages;

import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.google.common.base.Function;
import it.com.atlassian.gadgets.pages.AddApplicationLinkDialog;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ConfigureAppLinksPage
implements Page {
    @Inject
    private PageBinder pageBinder;
    @Inject
    private AtlassianWebDriver driver;
    @FindBy(id="add-application-link")
    WebElement addDialogLink;

    public String getUrl() {
        return "/plugins/servlet/applinks/listApplicationLinks";
    }

    public AddApplicationLinkDialog.Step1 openAddApplicationLinkDialog() {
        this.addDialogLink.click();
        return (AddApplicationLinkDialog.Step1)this.pageBinder.bind(AddApplicationLinkDialog.Step1.class, new Object[0]);
    }

    public void deleteAppLink(String name) {
        this.driver.waitUntilElementIsVisible(By.id((String)"applicationsList"));
        this.findDeleteLinkForApplication(name).click();
        this.driver.waitUntil((Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver from) {
                WebElement submitButton = from.findElement(By.cssSelector((String)"#delete-application-link-dialog .wizard-submit"));
                return submitButton != null && submitButton.getAttribute("disabled") != null && submitButton.getAttribute("disabled").equals("false");
            }
        });
        this.driver.findElement(By.cssSelector((String)"#delete-application-link-dialog .wizard-submit")).click();
        this.driver.waitUntilElementIsVisible(By.className((String)"applinks-message-bar"));
    }

    private WebElement findDeleteLinkForApplication(String name) {
        List tableRows = this.driver.findElements(By.cssSelector((String)"#applicationsList tr"));
        for (WebElement tableRow : tableRows) {
            if (!name.equals(tableRow.findElement(By.className((String)"application-name")).getText())) continue;
            return tableRow.findElement(By.className((String)"app-delete-link"));
        }
        return null;
    }
}

