/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.utils.Search;
import com.google.common.base.Function;
import it.com.atlassian.gadgets.pages.GadgetsDashboardPage;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddGadgetDialog {
    @Inject
    private AtlassianWebDriver driver;
    @Inject
    private PageBinder pageBinder;
    @FindBy(id="macro-browser-dialog")
    private WebElement dialog;
    @FindBy(id="macro-browser-search")
    private WebElement search;
    @FindBy(className="dialog-page-menu")
    private WebElement categories;
    @FindBy(id="category-all")
    private WebElement gadgetsList;
    private String currentCategory = "all";
    @FindBy(className="button-panel-cancel-link")
    private WebElement finishButton;
    @FindBy(className="add-by-url")
    private WebElement addGadgetToDirectoryButton;
    private final Integer dashboardId;

    public AddGadgetDialog(Integer dashboardId) {
        this.dashboardId = dashboardId;
    }

    @WaitUntil
    public void waitForVisible() {
        this.driver.waitUntilElementIsVisibleAt(By.className((String)"dialog-title"), (SearchContext)this.dialog);
    }

    public AddGadgetDialog searchFor(String value) {
        this.search.sendKeys(new CharSequence[]{value});
        return this;
    }

    public AddGadgetDialog waitFor(String gadgetTitle) {
        this.driver.waitUntilElementIsVisibleAt(By.id((String)this.gadgetId(gadgetTitle)), (SearchContext)this.dialog);
        return this;
    }

    public boolean isGadgetVisible(String gadgetTitle) {
        return this.driver.elementIsVisibleAt(By.id((String)this.gadgetId(gadgetTitle)), (SearchContext)this.dialog);
    }

    public List<String> getVisibleGadgets() {
        ArrayList<String> titles = new ArrayList<String>();
        for (WebElement gadget : Search.findVisibleElements((By)By.className((String)"macro-title"), (SearchContext)this.gadgetsList)) {
            titles.add(gadget.getText());
        }
        return titles;
    }

    public AddGadgetDialog setCategory(String categoryName) {
        for (WebElement cat : this.categories.findElements(By.className((String)"item-button"))) {
            String name = cat.getText().split(" ")[0];
            if (!categoryName.equalsIgnoreCase(name)) continue;
            cat.click();
            this.gadgetsList = categoryName.equalsIgnoreCase("all") ? this.dialog.findElement(By.id((String)"category-all")) : this.dialog.findElement(By.className((String)categoryName));
            this.currentCategory = categoryName;
            return this;
        }
        throw new IllegalArgumentException("Invalid category: " + categoryName);
    }

    public AddGadgetDialog addGadget(String gadgetTitle) {
        final WebElement addButton = this.dialog.findElement(By.id((String)this.gadgetId(gadgetTitle))).findElement(By.className((String)"macro-button-add"));
        addButton.click();
        this.driver.waitUntil((Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver input) {
                return addButton.isEnabled();
            }
        });
        return this;
    }

    public AddGadgetDialog addGadgetToDirectory(String gadgetUrl, String gadgetTitle) {
        this.addGadgetToDirectoryButton.click();
        this.driver.waitUntilElementIsLocated(By.id((String)"add-gadget-url"));
        this.driver.findElement(By.id((String)"add-gadget-url")).sendKeys(new CharSequence[]{gadgetUrl});
        this.driver.findElement(By.id((String)"add-gadget-submit")).click();
        this.driver.waitUntilElementIsLocated(By.id((String)this.gadgetId(gadgetTitle)));
        return this;
    }

    private String gadgetId(String gadgetTitle) {
        String prefix = this.currentCategory.equals("all") ? "" : this.currentCategory + "-";
        return prefix + "macro-" + gadgetTitle.replaceAll(" ", "").replaceAll(":", "");
    }

    public GadgetsDashboardPage finished() {
        this.finishButton.click();
        this.driver.waitUntilElementIsNotVisibleAt(By.className((String)"dialog-title"), (SearchContext)this.dialog);
        return (GadgetsDashboardPage)this.pageBinder.bind(GadgetsDashboardPage.class, new Object[]{this.dashboardId});
    }
}

