/*
 * Decompiled with CFR 0.152.
 */
package it.com.atlassian.gadgets.pages;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.webdriver.AtlassianWebDriver;
import it.com.atlassian.gadgets.pages.ConfigureAppLinksPage;
import java.net.URI;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddApplicationLinkDialog<S extends AddApplicationLinkDialog<S>> {
    @Inject
    protected AtlassianWebDriver driver;
    @Inject
    protected PageBinder pageBinder;
    @FindBy(id="add-application-link-dialog")
    protected WebElement dialog;

    AddApplicationLinkDialog() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonUalStep
    extends AddApplicationLinkDialog<NonUalStep> {
        @FindBy(id="application-types")
        private WebElement applicationTypesSelect;

        @WaitUntil
        public void waitForVisible() {
            this.driver.waitUntilElementIsVisibleAt(By.className((String)"non-ual-form"), (SearchContext)this.dialog);
        }

        public NonUalStep setApplicationName(String name) {
            WebElement applicationNameTextInput = this.driver.findElement(By.cssSelector((String)".non-ual-form input.application-name"));
            applicationNameTextInput.sendKeys(new CharSequence[]{name});
            return this;
        }

        public NonUalStep setApplicationType(String type) {
            Select select = new Select(this.applicationTypesSelect);
            select.selectByValue(type);
            return this;
        }

        public ConfigureAppLinksPage submit() {
            this.dialog.findElement(By.className((String)"wizard-submit")).click();
            this.driver.waitUntilElementIsNotVisibleAt(By.className((String)"non-ual-form"), (SearchContext)this.dialog);
            return (ConfigureAppLinksPage)this.pageBinder.bind(ConfigureAppLinksPage.class, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Step1
    extends AddApplicationLinkDialog<Step1> {
        @WaitUntil
        public void waitForVisible() {
            this.driver.waitUntilElementIsVisibleAt(By.className((String)"step-1-header"), (SearchContext)this.dialog);
        }

        public NonUalStep enterNonUalApplication(URI uri) {
            this.dialog.findElement(By.id((String)"application-url")).sendKeys(new CharSequence[]{uri.toASCIIString()});
            this.dialog.findElement(By.className((String)"applinks-next-button")).click();
            return (NonUalStep)this.pageBinder.bind(NonUalStep.class, new Object[0]);
        }
    }
}

