/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.servlet;

import com.atlassian.gadgets.GadgetSpecUriNotAllowedException;
import com.atlassian.gadgets.GadgetSpecUrlChecker;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.annotations.HtmlSafe;
import com.atlassian.templaterenderer.velocity.one.six.VelocityTemplateRenderer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GadgetSpecUrlRenderPermissionServletFilter
implements Filter {
    private static final String URL_PARAM = "url";
    private final GadgetSpecUrlChecker gadgetChecker;
    private final I18nResolver i18n;
    private final UserManager userManager;
    private final Log log = LogFactory.getLog(GadgetSpecUrlRenderPermissionServletFilter.class);
    private final VelocityTemplateRenderer renderer;

    public GadgetSpecUrlRenderPermissionServletFilter(GadgetSpecUrlChecker gadgetChecker, @ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager, @ComponentImport VelocityTemplateRenderer renderer) {
        Preconditions.checkNotNull((Object)gadgetChecker, (Object)"gadgetChecker");
        Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.gadgetChecker = gadgetChecker;
        this.i18n = i18nResolver;
        this.userManager = userManager;
        this.renderer = renderer;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        URI gadgetSpecUri;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String uri = req.getParameter(URL_PARAM);
        if (StringUtils.isBlank((String)uri)) {
            chain.doFilter(request, response);
            return;
        }
        try {
            gadgetSpecUri = new URI(uri);
        }
        catch (URISyntaxException urise) {
            this.log.warn((Object)"GadgetSpecUrlRenderPermissionServletFilter: couldn't parse URI from request", (Throwable)urise);
            resp.sendError(400, "couldn't parse '" + uri + "' as a URI");
            return;
        }
        try {
            this.gadgetChecker.assertRenderable(gadgetSpecUri.toString());
        }
        catch (GadgetSpecUriNotAllowedException igsue) {
            resp.setStatus(410);
            resp.setContentType("text/html");
            if (resp.getWriter() != null) {
                String userName = this.userManager.getRemoteUsername(req);
                boolean isAdmin = userName != null && this.userManager.isSystemAdmin(userName);
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("reason", igsue.getMessage());
                context.put("message", this.i18n.getText("error.gadget.gone"));
                context.put("gadgetUrl", isAdmin ? gadgetSpecUri : "");
                context.put("unescaper", Unescaper.getSingleton());
                this.renderer.render("/gadgetRemovedError.vm", context, (Writer)resp.getWriter());
            }
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public static class Unescaper {
        private static Unescaper singleton = new Unescaper();

        @HtmlSafe
        public String html(String text) {
            return text;
        }

        public static Unescaper getSingleton() {
            return singleton;
        }
    }
}

