/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.local;

import com.atlassian.gadgets.LocalGadgetSpecProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;

@Singleton
public class LocalGadgetSpecFactory
implements GadgetSpecFactory {
    private final Parser parser;
    private final Cache cache;
    private final GadgetSpecFactory fallback;
    static final String RAW_GADGETSPEC_XML_PARAM_NAME = "rawxml";
    static final Uri RAW_GADGET_URI = Uri.parse((String)"http://localhost/raw.xml");

    @Inject
    public LocalGadgetSpecFactory(Iterable<LocalGadgetSpecProvider> providers, @Named(value="fallback") GadgetSpecFactory fallback) {
        this.parser = new Parser((Iterable)Preconditions.checkNotNull(providers, (Object)"providers"));
        this.cache = new Cache(this.parser);
        this.fallback = (GadgetSpecFactory)Preconditions.checkNotNull((Object)fallback, (Object)"fallback");
    }

    public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
        String rawxml = context.getParameter(RAW_GADGETSPEC_XML_PARAM_NAME);
        if (rawxml != null) {
            return new GadgetSpec(RAW_GADGET_URI, rawxml);
        }
        return this.getGadgetSpec(context.getUrl(), context.getIgnoreCache());
    }

    public GadgetSpec getGadgetSpec(URI gadgetUri, boolean ignoreCache) throws GadgetException {
        CacheableGadgetSpec spec = ignoreCache ? this.parser.get(gadgetUri) : this.cache.get(gadgetUri);
        if (spec != null) {
            return spec;
        }
        return this.fallback.getGadgetSpec(gadgetUri, ignoreCache);
    }

    private static final class Parser {
        private static final Log log = LogFactory.getLog(Parser.class);
        private final Iterable<LocalGadgetSpecProvider> providers;

        public Parser(Iterable<LocalGadgetSpecProvider> providers) {
            this.providers = providers;
        }

        public CacheableGadgetSpec get(URI gadgetUri) throws GadgetException {
            for (LocalGadgetSpecProvider provider : this.providers) {
                block10: {
                    try {
                        if (!provider.contains(gadgetUri)) {
                        }
                        break block10;
                    }
                    catch (RuntimeException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Could not determine whether " + provider + " contains " + gadgetUri), (Throwable)e);
                    }
                    continue;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    provider.writeGadgetSpecTo(gadgetUri, (OutputStream)output);
                }
                catch (RuntimeException e) {
                    if (log.isDebugEnabled()) {
                        log.warn((Object)("Could not retrieve gadget spec " + gadgetUri + " from " + provider), (Throwable)e);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Could not retrieve gadget spec " + gadgetUri + " from " + provider + ": " + e.getMessage()));
                    continue;
                }
                catch (IOException e) {
                    throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, (Throwable)e);
                }
                try {
                    return new CacheableGadgetSpec(provider, gadgetUri, new String(output.toByteArray(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)"UTF-8 encoding is required by the Java specification");
                }
            }
            return null;
        }
    }

    private static final class Cache {
        private final Parser parser;
        private final Map<URI, CacheableGadgetSpec> cache = new MapMaker().softValues().makeMap();

        public Cache(Parser parser) {
            this.parser = (Parser)Preconditions.checkNotNull((Object)parser, (Object)"parser");
        }

        public CacheableGadgetSpec get(URI gadgetUri) throws GadgetException {
            CacheableGadgetSpec spec = this.cache.get(gadgetUri);
            if (spec != null && !spec.isExpired()) {
                return spec;
            }
            spec = this.parser.get(gadgetUri);
            if (spec == null) {
                return null;
            }
            this.cache.put(gadgetUri, spec);
            return spec;
        }
    }

    private static final class CacheableGadgetSpec
    extends GadgetSpec {
        private static final Log log = LogFactory.getLog(CacheableGadgetSpec.class);
        private final URI uri;
        private final LocalGadgetSpecProvider provider;
        private final Date cachedAt = new Date();

        public CacheableGadgetSpec(LocalGadgetSpecProvider provider, URI uri, String xml) throws SpecParserException {
            super(Uri.fromJavaUri((URI)uri), xml);
            this.provider = (LocalGadgetSpecProvider)Preconditions.checkNotNull((Object)provider, (Object)"provider");
            this.uri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"uri");
        }

        public boolean isExpired() {
            try {
                return this.provider.getLastModified(this.uri).after(this.cachedAt);
            }
            catch (RuntimeException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not determine whether " + this.provider + " contains " + this.uri), (Throwable)e);
                }
                return true;
            }
        }
    }
}

