/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.http;

import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.atlassian.gadgets.util.HttpTimeoutsProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpCacheKey;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

@Singleton
public class HttpClientFetcher
implements HttpFetcher {
    private final Log log = LogFactory.getLog(HttpClientFetcher.class);
    private final HttpCache cache;
    private final Whitelist whitelist;
    private final HttpTimeoutsProvider httpTimeoutsProvider;

    @Inject
    public HttpClientFetcher(HttpCache cache, Whitelist whitelist, ApplicationProperties applicationProperties) {
        this.cache = cache;
        this.whitelist = whitelist;
        this.httpTimeoutsProvider = new HttpTimeoutsProvider(applicationProperties);
    }

    public org.apache.shindig.gadgets.http.HttpResponse fetch(HttpRequest request) {
        if (!this.whitelist.allows(request.getUri().toJavaUri())) {
            this.log.warn((Object)("A request to " + request.getUri() + " has been denied.  To allow requests to this URL add the application URL to your whitelist (http://confluence.atlassian.com/x/KQfCDQ )."));
            return new HttpResponseBuilder().setHttpStatusCode(403).setHeader("Content-Type", "text/plain").setResponseString("Requests to " + request.getUri() + " are not allowed.  See your administrator about configuring a whitelist entry for this destination (http://confluence.atlassian.com/x/KQfCDQ ).").create();
        }
        HttpCacheKey cacheKey = new HttpCacheKey(request);
        org.apache.shindig.gadgets.http.HttpResponse response = this.cache.getResponse(cacheKey, request);
        if (response != null) {
            return response;
        }
        try {
            HttpResponse hcResponse;
            HttpUriRequest hcRequest = this.newHcRequest(request);
            if (request.getPostBodyLength() > 0) {
                ((HttpEntityEnclosingRequest)hcRequest).setEntity((HttpEntity)new InputStreamEntity(request.getPostBody(), (long)request.getPostBodyLength()));
            }
            try {
                hcResponse = this.newHttpClient("TLSv1", request).execute(hcRequest);
            }
            catch (SSLException e) {
                this.log.debug((Object)"SSL Exception establishing connection with TLSv1 protocol. Falling back to SSLv3.", (Throwable)e);
                hcResponse = this.newHttpClient("SSLv3", request).execute(hcRequest);
            }
            response = this.makeResponse(hcResponse);
            return this.cache.addResponse(cacheKey, request, response);
        }
        catch (IOException e) {
            if (e instanceof SocketTimeoutException || e instanceof SocketException) {
                return org.apache.shindig.gadgets.http.HttpResponse.timeout();
            }
            this.log.error((Object)"Unable to retrieve response", (Throwable)e);
            return org.apache.shindig.gadgets.http.HttpResponse.error();
        }
    }

    private HttpClient newHttpClient(String sslProtocol, HttpRequest request) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.httpTimeoutsProvider.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.httpTimeoutsProvider.getSocketTimeout());
        if (request.getFollowRedirects()) {
            params.setBooleanParameter("http.protocol.handle-redirects", true);
            params.setIntParameter("http.protocol.max-redirects", 3);
        }
        params.setParameter("http.default-headers", (Object)ImmutableSet.of((Object)new BasicHeader("Accept-Encoding", "gzip, deflate")));
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        client.setRoutePlanner((HttpRoutePlanner)routePlanner);
        client.addResponseInterceptor((HttpResponseInterceptor)new GzipDeflatingInterceptor());
        client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)new CustomSSLSocketFactory(sslProtocol), 443));
        return client;
    }

    private HttpUriRequest newHcRequest(HttpRequest request) throws IOException {
        URI uri = request.getUri().toJavaUri();
        HttpUriRequest httpUriRequest = HttpMethod.valueOf(request.getMethod()).newMessage(uri);
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            httpUriRequest.addHeader((String)entry.getKey(), StringUtils.join((Collection)((Collection)entry.getValue()), (char)','));
        }
        return httpUriRequest;
    }

    private org.apache.shindig.gadgets.http.HttpResponse makeResponse(HttpResponse hcResponse) throws IOException {
        HttpResponseBuilder builder = new HttpResponseBuilder();
        for (Header header : hcResponse.getAllHeaders()) {
            builder.addHeader(header.getName(), header.getValue());
        }
        return builder.setHttpStatusCode(hcResponse.getStatusLine().getStatusCode()).setResponse(IOUtils.toByteArray((InputStream)hcResponse.getEntity().getContent())).create();
    }

    private static enum HttpMethod {
        GET,
        POST,
        DELETE,
        PUT,
        HEAD,
        OPTIONS,
        TRACE;


        public HttpUriRequest newMessage(URI uri) {
            switch (this) {
                case GET: {
                    return new HttpGet(uri);
                }
                case POST: {
                    return new HttpPost(uri);
                }
                case DELETE: {
                    return new HttpDelete(uri);
                }
                case PUT: {
                    return new HttpPut(uri);
                }
                case HEAD: {
                    return new HttpHead(uri);
                }
                case OPTIONS: {
                    return new HttpOptions(uri);
                }
                case TRACE: {
                    return new HttpTrace(uri);
                }
            }
            throw new IllegalStateException("Just not possible");
        }
    }

    private static final class InflatingEntity
    extends InputStreamDecoratingHttpEntity {
        public InflatingEntity(HttpEntity entity) {
            super(entity);
        }

        @Override
        protected InputStream decorate(InputStream is) throws IOException {
            return new InflaterInputStream(is, new Inflater(true));
        }
    }

    private static final class GzipDecompressingEntity
    extends InputStreamDecoratingHttpEntity {
        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        @Override
        protected InputStream decorate(InputStream is) throws IOException {
            return new GZIPInputStream(is);
        }
    }

    private static abstract class InputStreamDecoratingHttpEntity
    extends HttpEntityWrapper {
        public InputStreamDecoratingHttpEntity(HttpEntity wrapped) {
            super(wrapped);
        }

        public final InputStream getContent() throws IOException, IllegalStateException {
            return this.decorate(this.wrappedEntity.getContent());
        }

        public final long getContentLength() {
            return -1L;
        }

        protected abstract InputStream decorate(InputStream var1) throws IOException;
    }

    private static final class GzipDeflatingInterceptor
    implements HttpResponseInterceptor {
        private GzipDeflatingInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpEntity entity = response.getEntity();
            Header ceheader = entity.getContentEncoding();
            if (ceheader != null) {
                HeaderElement[] codecs = ceheader.getElements();
                for (int i = 0; i < codecs.length; ++i) {
                    if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                    if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity((HttpEntity)new InflatingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    private static final class CustomSSLSocketFactory
    implements LayeredSocketFactory {
        private final LayeredSocketFactory factory = SSLSocketFactory.getSocketFactory();
        private final String protocol;

        public CustomSSLSocketFactory(String protocol) {
            this.protocol = protocol;
        }

        public Socket createSocket() throws IOException {
            SSLSocket socket = (SSLSocket)this.factory.createSocket();
            socket.setEnabledProtocols(new String[]{this.protocol});
            return socket;
        }

        public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            return this.factory.connectSocket(sock, host, port, localAddress, localPort, params);
        }

        public boolean isSecure(Socket sock) throws IllegalArgumentException {
            return this.factory.isSecure(sock);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.factory.createSocket(socket, host, port, autoClose);
        }
    }
}

