/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal;

import com.atlassian.gadgets.GadgetSpecUriNotAllowedException;
import com.atlassian.gadgets.GadgetSpecUrlChecker;
import com.atlassian.gadgets.Vote;
import com.atlassian.gadgets.opensocial.spi.GadgetSpecUrlRenderPermission;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GadgetSpecUrlCheckerImpl
implements GadgetSpecUrlChecker {
    private final Log log = LogFactory.getLog(GadgetSpecUrlCheckerImpl.class);
    private final Iterable<GadgetSpecUrlRenderPermission> permissions;

    public GadgetSpecUrlCheckerImpl(Iterable<GadgetSpecUrlRenderPermission> permissions) {
        Preconditions.checkNotNull(permissions);
        this.permissions = permissions;
    }

    public void assertRenderable(String gadgetSpecUri) {
        Preconditions.checkNotNull((Object)gadgetSpecUri);
        if (Iterables.isEmpty(this.permissions)) {
            throw new GadgetSpecUriNotAllowedException("no permissions defined: all rendering rejected by default");
        }
        int passes = 0;
        int totalPermissions = 0;
        for (GadgetSpecUrlRenderPermission permission : this.permissions) {
            Vote lastVote;
            try {
                lastVote = permission.voteOn(gadgetSpecUri);
            }
            catch (RuntimeException re) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn((Object)("Could not check gadget render permission with " + permission), (Throwable)re);
                } else if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("Could not check gadget render permission with " + permission + ": " + re.getMessage()));
                }
                throw new GadgetSpecUriNotAllowedException("exception while checking permission " + permission + ": " + re.getMessage());
            }
            switch (lastVote) {
                case DENY: {
                    throw new GadgetSpecUriNotAllowedException("permission '" + permission + "' vetoed render of gadget at " + gadgetSpecUri);
                }
                case PASS: {
                    ++passes;
                }
            }
            ++totalPermissions;
        }
        if (passes == totalPermissions) {
            throw new GadgetSpecUriNotAllowedException("no ALLOW permission for gadget at " + gadgetSpecUri);
        }
    }
}

