/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.opensocial.internal;

import com.atlassian.gadgets.opensocial.OpenSocialRequestContext;
import com.atlassian.gadgets.opensocial.internal.ShindigOpenSocialTypeAdapter;
import com.atlassian.gadgets.opensocial.model.Person;
import com.atlassian.gadgets.opensocial.spi.PersonServiceException;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShindigPersonServiceImpl
implements PersonService {
    private final com.atlassian.gadgets.opensocial.spi.PersonService personService;
    private final TransactionTemplate txTemplate;
    private static final Comparator<org.apache.shindig.social.opensocial.model.Person> NAME_COMPARATOR = new Comparator<org.apache.shindig.social.opensocial.model.Person>(){

        @Override
        public int compare(org.apache.shindig.social.opensocial.model.Person person, org.apache.shindig.social.opensocial.model.Person person1) {
            String name = person.getName().getFormatted();
            String name1 = person1.getName().getFormatted();
            return name.compareTo(name1);
        }
    };

    @Autowired
    public ShindigPersonServiceImpl(com.atlassian.gadgets.opensocial.spi.PersonService personService, TransactionTemplate txTemplate) {
        this.personService = personService;
        this.txTemplate = txTemplate;
    }

    public Future<RestfulCollection<org.apache.shindig.social.opensocial.model.Person>> getPeople(final Set<UserId> userIds, final GroupId groupId, CollectionOptions collectionOptions, Set<String> fields, final SecurityToken token) throws SocialSpiException {
        try {
            Set people = (Set)this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    return ShindigOpenSocialTypeAdapter.getPeopleFromUserIds(ShindigPersonServiceImpl.this.personService, userIds, groupId, token);
                }
            });
            List shindigPeople = new ArrayList(Collections2.transform((Collection)people, ShindigOpenSocialTypeAdapter.personToShindigPersonFunction()));
            if (collectionOptions.getSortBy().equals(Person.Field.NAME.toString())) {
                Collections.sort(shindigPeople, NAME_COMPARATOR);
            }
            if (collectionOptions.getSortOrder().equals((Object)PersonService.SortOrder.descending)) {
                Collections.reverse(shindigPeople);
            }
            int totalSize = shindigPeople.size();
            int last = collectionOptions.getFirst() + collectionOptions.getMax();
            shindigPeople = shindigPeople.subList(Math.min(collectionOptions.getFirst(), totalSize), Math.min(last, totalSize));
            return ImmediateFuture.newInstance((Object)new RestfulCollection(shindigPeople, collectionOptions.getFirst(), totalSize));
        }
        catch (PersonServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public Future<org.apache.shindig.social.opensocial.model.Person> getPerson(final UserId id, Set<String> fields, final SecurityToken token) throws SocialSpiException {
        try {
            final OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
            Person person = (Person)this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    return ShindigPersonServiceImpl.this.personService.getPerson(id.getUserId(token), openSocialRequestContext);
                }
            });
            if (person == null) {
                throw new SocialSpiException(ResponseError.BAD_REQUEST, "Person " + id.getUserId(token) + " not found");
            }
            return ImmediateFuture.newInstance((Object)ShindigOpenSocialTypeAdapter.convertPersonToShindigPerson(person));
        }
        catch (PersonServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }
}

