/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal.impl;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.GadgetParsingException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetSpecProvider;
import com.atlassian.gadgets.dashboard.DashboardItemModules;
import com.atlassian.gadgets.directory.Directory;
import com.atlassian.gadgets.directory.internal.impl.AbstractDirectoryEntryProvider;
import com.atlassian.gadgets.directory.internal.impl.GadgetSpecDirectoryEntry;
import com.atlassian.gadgets.plugins.DashboardItemModuleDescriptor;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Scanned
public class GadgetSpecProviderDirectoryEntryProvider
extends AbstractDirectoryEntryProvider<URI> {
    private static final Log LOG = LogFactory.getLog(GadgetSpecProviderDirectoryEntryProvider.class);
    private final Collection<GadgetSpecProvider> gadgetSpecProviders;
    private final Collection<GadgetSpecProvider> localGadgetSpecProviders;
    private final GadgetSpecProviderToURI gadgetSpecProviderToURI;

    public GadgetSpecProviderDirectoryEntryProvider(GadgetSpecFactory gadgetSpecFactory, Collection<GadgetSpecProvider> gadgetSpecProviders, Collection<GadgetSpecProvider> localGadgetSpecProviders, Collection<DashboardItemModules> dashboardItemModules) {
        super(gadgetSpecFactory);
        this.gadgetSpecProviders = gadgetSpecProviders;
        this.localGadgetSpecProviders = localGadgetSpecProviders;
        this.gadgetSpecProviderToURI = new GadgetSpecProviderToURI(new DashboardItemDefinitionReplacesOpenSocialSpecPredicate(dashboardItemModules));
    }

    @Override
    public boolean contains(final URI gadgetSpecUri) {
        return Iterables.any(this.gadgetSpecProviders, (Predicate)new Predicate<GadgetSpecProvider>(){

            public boolean apply(GadgetSpecProvider provider) {
                try {
                    return provider.contains(gadgetSpecUri);
                }
                catch (RuntimeException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Could not determine whether " + provider + " contains " + gadgetSpecUri), (Throwable)e);
                    }
                    return false;
                }
            }
        });
    }

    @Override
    protected Iterable<URI> internalEntries(Directory.EntryScope entryScope) {
        HashSet internalEntries;
        switch (entryScope) {
            case ALL: {
                internalEntries = this.allInternalEntries();
                break;
            }
            case LOCAL: {
                internalEntries = this.localInternalEntries();
                break;
            }
            case EXTERNAL: {
                internalEntries = Sets.newHashSet(this.allInternalEntries());
                Iterables.removeAll((Iterable)internalEntries, (Collection)Sets.newHashSet(this.localInternalEntries()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported entry scope: " + entryScope);
            }
        }
        return internalEntries;
    }

    private Iterable<URI> allInternalEntries() {
        return Iterables.concat((Iterable)Iterables.transform(this.gadgetSpecProviders, (Function)this.gadgetSpecProviderToURI));
    }

    private Iterable<URI> localInternalEntries() {
        return Iterables.concat((Iterable)Iterables.transform(this.localGadgetSpecProviders, (Function)this.gadgetSpecProviderToURI));
    }

    @Override
    protected Function<URI, Directory.OpenSocialDirectoryEntry> convertToLocalizedDirectoryEntry(final GadgetRequestContext gadgetRequestContext) {
        return new Function<URI, Directory.OpenSocialDirectoryEntry>(){

            public Directory.OpenSocialDirectoryEntry apply(URI gadgetSpecUri) {
                try {
                    return new GadgetSpecDirectoryEntry(GadgetSpecProviderDirectoryEntryProvider.this.getGadgetSpec(gadgetSpecUri, gadgetRequestContext), false, null);
                }
                catch (GadgetParsingException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Couldn't retrieve " + gadgetSpecUri), (Throwable)e);
                    }
                    return null;
                }
            }
        };
    }

    public String toString() {
        return "application-provided gadget specs";
    }

    private static final class DashboardItemDefinitionReplacesOpenSocialSpecPredicate
    implements Predicate<URI> {
        private final Collection<DashboardItemModules> dashboardItemModules;

        private DashboardItemDefinitionReplacesOpenSocialSpecPredicate(Collection<DashboardItemModules> dashboardItemModules) {
            this.dashboardItemModules = dashboardItemModules;
        }

        public boolean apply(final URI specURI) {
            Iterable descriptors = Iterables.concat((Iterable)Iterables.transform(this.dashboardItemModules, dim -> dim.getDashboardItemsWithDirectoryDefinition()));
            return Iterables.any((Iterable)descriptors, (Predicate)new Predicate<DashboardItemModuleDescriptor>(){

                public boolean apply(DashboardItemModuleDescriptor dashboardItemModuleDescriptor) {
                    Option specUriToReplace = dashboardItemModuleDescriptor.getGadgetSpecUriToReplace();
                    return specUriToReplace.isDefined() && specURI.toASCIIString().equals(specUriToReplace.get());
                }
            });
        }
    }

    private static final class GadgetSpecProviderToURI
    implements Function<GadgetSpecProvider, Iterable<URI>> {
        private final DashboardItemDefinitionReplacesOpenSocialSpecPredicate dashboardItemDefinitionReplacesOpenSocialSpecPredicate;

        public GadgetSpecProviderToURI(DashboardItemDefinitionReplacesOpenSocialSpecPredicate dashboardItemDefinitionReplacesOpenSocialSpecPredicate) {
            this.dashboardItemDefinitionReplacesOpenSocialSpecPredicate = dashboardItemDefinitionReplacesOpenSocialSpecPredicate;
        }

        public Iterable<URI> apply(GadgetSpecProvider provider) {
            try {
                return Iterables.filter((Iterable)provider.entries(), (Predicate)Predicates.not((Predicate)this.dashboardItemDefinitionReplacesOpenSocialSpecPredicate));
            }
            catch (RuntimeException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)("Could not retrieve directory entries from " + provider), (Throwable)e);
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Could not retrieve directory entries from " + provider + ": " + e.getMessage()));
                }
                return Collections.emptySet();
            }
        }
    }
}

