/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal;

import com.atlassian.gadgets.util.HttpTimeoutsProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.annotations.VisibleForTesting;
import java.net.ProxySelector;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.codehaus.httpcache4j.cache.CacheStorage;
import org.codehaus.httpcache4j.cache.HTTPCache;
import org.codehaus.httpcache4j.cache.MemoryCacheStorage;
import org.codehaus.httpcache4j.resolver.HTTPClientResponseResolver;
import org.codehaus.httpcache4j.resolver.ResponseResolver;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;

public class HttpCache
extends HTTPCache
implements DisposableBean {
    private final HttpClient client;
    private final HttpTimeoutsProvider httpTimeoutsProvider;

    @Autowired
    public HttpCache(@ComponentImport ApplicationProperties applicationProperties) {
        super((CacheStorage)new MemoryCacheStorage());
        this.httpTimeoutsProvider = new HttpTimeoutsProvider(applicationProperties);
        this.client = this.createHttpClient();
        this.setResolver((ResponseResolver)new HTTPClientResponseResolver(this.client));
    }

    @VisibleForTesting
    HttpClient createHttpClient() {
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(this.httpTimeoutsProvider.getSocketTimeout()).setTcpNoDelay(true).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(15000).setConnectionRequestTimeout(5000).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(){

            protected void finalize() throws Throwable {
            }
        };
        return HttpClients.custom().setUserAgent("Atlassian-Gadgets-HttpClient").setRoutePlanner((HttpRoutePlanner)routePlanner).setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public void destroy() {
        this.client.getConnectionManager().shutdown();
    }
}

