/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal.impl;

import com.atlassian.gadgets.GadgetParsingException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.directory.Directory;
import com.atlassian.gadgets.directory.internal.impl.AbstractDirectoryEntryProvider;
import com.atlassian.gadgets.directory.internal.impl.GadgetSpecDirectoryEntry;
import com.atlassian.gadgets.plugins.PluginGadgetSpec;
import com.atlassian.gadgets.plugins.PluginGadgetSpecEventListener;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PluginExternalGadgetSpecDirectoryEntryProvider
extends AbstractDirectoryEntryProvider<URI>
implements PluginGadgetSpecEventListener {
    private final Set<URI> entries = new HashSet<URI>();
    private final ReadWriteLock entriesLock = new ReentrantReadWriteLock();

    public PluginExternalGadgetSpecDirectoryEntryProvider(GadgetSpecFactory gadgetSpecFactory, @ComponentImport ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        super((GadgetSpecFactory)Preconditions.checkNotNull((Object)gadgetSpecFactory, (Object)"gadgetSpecFactory"), (ThreadLocalDelegateExecutorFactory)Preconditions.checkNotNull((Object)threadLocalDelegateExecutorFactory, (Object)"threadLocalDelegateExecutorFactory"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(URI gadgetSpecUri) {
        this.entriesLock.readLock().lock();
        try {
            boolean bl = this.entries.contains(gadgetSpecUri);
            return bl;
        }
        finally {
            this.entriesLock.readLock().unlock();
        }
    }

    public void pluginGadgetSpecEnabled(PluginGadgetSpec pluginGadgetSpec) throws GadgetParsingException {
        if (pluginGadgetSpec.isHostedExternally()) {
            this.add(URI.create(pluginGadgetSpec.getLocation()));
        }
    }

    public void pluginGadgetSpecDisabled(PluginGadgetSpec pluginGadgetSpec) {
        if (pluginGadgetSpec.isHostedExternally()) {
            this.remove(URI.create(pluginGadgetSpec.getLocation()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterable<URI> internalEntries() {
        this.entriesLock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.entries);
            return immutableSet;
        }
        finally {
            this.entriesLock.readLock().unlock();
        }
    }

    @Override
    protected Function<URI, Directory.Entry> convertToLocalizedDirectoryEntry(final GadgetRequestContext gadgetRequestContext) {
        return new Function<URI, Directory.Entry>(){

            public Directory.Entry apply(URI gadgetSpecUri) {
                try {
                    return new GadgetSpecDirectoryEntry(PluginExternalGadgetSpecDirectoryEntryProvider.this.getGadgetSpec(gadgetSpecUri, gadgetRequestContext), false, null);
                }
                catch (GadgetParsingException e) {
                    return null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(URI gadgetSpecUri) throws GadgetParsingException {
        this.entriesLock.writeLock().lock();
        try {
            if (!this.entries.contains(gadgetSpecUri)) {
                this.validateGadgetSpec(gadgetSpecUri);
                this.entries.add(gadgetSpecUri);
            }
        }
        finally {
            this.entriesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(URI gadgetSpecUri) {
        this.entriesLock.writeLock().lock();
        try {
            this.entries.remove(gadgetSpecUri);
        }
        finally {
            this.entriesLock.writeLock().unlock();
        }
    }

    private void validateGadgetSpec(URI gadgetSpecUri) throws GadgetParsingException {
        this.getGadgetSpec(gadgetSpecUri, GadgetRequestContext.NO_CURRENT_REQUEST);
    }

    public String toString() {
        return "plugin-provided external gadget specs";
    }
}

