/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal.impl;

import com.atlassian.gadgets.GadgetParsingException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.directory.Directory;
import com.atlassian.gadgets.directory.internal.DirectoryEntryProvider;
import com.atlassian.gadgets.spec.GadgetSpec;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractDirectoryEntryProvider<T>
implements DirectoryEntryProvider,
DisposableBean {
    private final Log log = LogFactory.getLog(this.getClass());
    private final GadgetSpecFactory gadgetSpecFactory;
    private final ExecutorService executor;

    public AbstractDirectoryEntryProvider(GadgetSpecFactory gadgetSpecFactory, @ComponentImport ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.gadgetSpecFactory = gadgetSpecFactory;
        this.executor = threadLocalDelegateExecutorFactory.createExecutorService(Executors.newFixedThreadPool(15, new DirectoryEntryThreadFactory()));
    }

    @Override
    public final Iterable<Directory.Entry> entries(final GadgetRequestContext gadgetRequestContext) {
        ImmutableList internalEntries = ImmutableList.copyOf(this.internalEntries());
        ExecutorCompletionService<Directory.Entry> completionService = new ExecutorCompletionService<Directory.Entry>(this.executor);
        for (final Object internalEntry : internalEntries) {
            completionService.submit(new Callable<Directory.Entry>(){

                @Override
                public Directory.Entry call() throws Exception {
                    return (Directory.Entry)AbstractDirectoryEntryProvider.this.convertToLocalizedDirectoryEntry(gadgetRequestContext).apply(internalEntry);
                }
            });
        }
        ArrayList<Directory.Entry> ret = new ArrayList<Directory.Entry>();
        for (int i = 0; i < internalEntries.size(); ++i) {
            try {
                Directory.Entry entry = (Directory.Entry)completionService.take().get();
                if (entry == null) continue;
                ret.add(entry);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                this.log.error((Object)"Unknown error resolving directory entry.", (Throwable)e);
            }
        }
        return ret;
    }

    protected abstract Iterable<T> internalEntries();

    protected abstract Function<T, Directory.Entry> convertToLocalizedDirectoryEntry(GadgetRequestContext var1);

    protected final GadgetSpec getGadgetSpec(URI gadgetSpecUri, GadgetRequestContext gadgetRequestContext) throws GadgetParsingException {
        return this.gadgetSpecFactory.getGadgetSpec(gadgetSpecUri, gadgetRequestContext);
    }

    public void destroy() throws Exception {
        this.executor.shutdown();
    }

    private static class DirectoryEntryThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadId = new AtomicLong(0L);

        private DirectoryEntryThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, "DirectoryEntryResolverThread-" + this.threadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }
}

