/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DirectoryConfigServlet
extends HttpServlet {
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;

    public DirectoryConfigServlet(TemplateRenderer renderer, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.loginUriProvider = (LoginUriProvider)Preconditions.checkNotNull((Object)loginUriProvider, (Object)"loginUriProvider");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAdmin(request)) {
            URI returnUri = URI.create(request.getServletPath() + (request.getQueryString() != null ? "?" + request.getQueryString() : ""));
            response.sendRedirect(this.loginUriProvider.getLoginUri(returnUri).toString());
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("directory-config.vm", (Writer)response.getWriter());
    }

    private boolean isAdmin(HttpServletRequest req) {
        String user = this.userManager.getRemoteUsername(req);
        return user != null && this.userManager.isSystemAdmin(user);
    }
}

