/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.velocity;

import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.internal.AbstractViewComponent;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.Tab;
import com.atlassian.gadgets.dashboard.internal.util.HelpLinkResolver;
import com.atlassian.gadgets.dashboard.internal.velocity.DashboardEmbedder;
import com.atlassian.gadgets.view.View;
import com.atlassian.gadgets.view.ViewType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

class DashboardView
extends AbstractViewComponent {
    private final Dashboard dashboard;
    private final boolean writable;
    private final boolean canAddExternalGadgetsToDirectory;
    private final String username;
    private final TemplateRenderer renderer;
    private final Iterable<Tab> tabs;
    private final GadgetRequestContext gadgetRequestContext;
    private final String templateName;
    private final HelpLinkResolver linkResolver;
    private final int maxGadgets;
    private final DashboardEmbedder dashboardEmbedder;
    private final ApplicationProperties applicationProperties;

    DashboardView(TemplateRenderer renderer, Iterable<Tab> tabs, Dashboard dashboard, String username, int maxGadgets, GadgetRequestContext gadgetRequestContext, boolean writable, boolean canAddExternalGadgetsToDirectory, DashboardEmbedder dashboardEmbedder, @ComponentImport HelpPathResolver helpPathResolver, @ComponentImport ApplicationProperties applicationProperties) {
        super(dashboard.getId().toString(), dashboard.getTitle());
        this.renderer = renderer;
        this.tabs = tabs;
        this.applicationProperties = applicationProperties;
        this.templateName = "/dashboard.vm";
        this.dashboard = dashboard;
        this.username = username;
        this.gadgetRequestContext = gadgetRequestContext;
        this.writable = writable;
        this.canAddExternalGadgetsToDirectory = canAddExternalGadgetsToDirectory;
        this.linkResolver = new HelpLinkResolver(helpPathResolver);
        this.maxGadgets = maxGadgets;
        this.dashboardEmbedder = dashboardEmbedder;
    }

    public final void writeTo(Writer writer) throws RenderingException, IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("id", this.getId());
        context.put("title", this.getTitle());
        context.put("writer", writer);
        context.put("dashboard", this.dashboard);
        context.put("username", this.username);
        context.put("viewSettings", new View.Builder().viewType(ViewType.DEFAULT).writable(this.writable).build());
        context.put("canAddExternalGadgetsToDirectory", this.canAddExternalGadgetsToDirectory);
        context.put("tabs", this.tabs);
        context.put("gadgetRequestContext", this.gadgetRequestContext);
        context.put("linkLearnHow", this.linkResolver.getLink("how.to.create.gadgets"));
        context.put("linkFindMore", this.linkResolver.getLink("find.more.gadgets"));
        context.put("whitelistExternalGadgets", this.linkResolver.getLink("whitelist.external.gadget"));
        context.put("linkLearnMoreAboutGadgets", this.linkResolver.getLink("learn.more.about.gadgets"));
        context.put("linkPluginHintGadgets", this.linkResolver.getLink("plugin.hint.gadgets"));
        String showMarketingHints = this.applicationProperties.getPropertyValue("show.plugin.marketing.hints");
        context.put("showMarketingPluginHints", showMarketingHints == null || Boolean.valueOf(showMarketingHints) != false);
        context.put("maxGadgets", this.maxGadgets);
        context.put("writable", this.writable);
        context.put("embed", this.dashboardEmbedder);
        this.renderer.render(this.templateName, context, writer);
    }
}

