/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.util;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.HelpPath;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public final class HelpLinkResolver {
    private final Properties prop;
    private final String baseUrl;
    private final HelpPathResolver helpPathResolver;

    public HelpLinkResolver(@ComponentImport HelpPathResolver helpPathResolver) {
        this.helpPathResolver = helpPathResolver;
        this.prop = new Properties();
        InputStream is = this.getClass().getResourceAsStream("/gadget-help-paths.properties");
        try {
            this.prop.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        this.baseUrl = this.prop.getProperty("base.url");
    }

    public String getLink(String name) {
        HelpPath helpPath;
        Preconditions.checkNotNull((Object)name, (Object)"name");
        String url = null;
        if (this.prop.containsKey(name)) {
            url = this.baseUrl + this.prop.getProperty(name);
        } else if (this.helpPathResolver != null && (helpPath = this.helpPathResolver.getHelpPath(name)) != null) {
            url = helpPath.getUrl();
        }
        if (url == null) {
            url = this.baseUrl + this.prop.getProperty("default.page");
        }
        return url;
    }
}

