/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.gadgets.dashboard.internal.UserPref;
import com.atlassian.gadgets.dashboard.internal.rest.representations.UserPrefRepresentation;
import com.atlassian.plugin.util.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public final class UserPrefsRepresentation {
    @XmlElement
    private final String action;
    @XmlElement
    private final List<UserPrefRepresentation> fields;

    private UserPrefsRepresentation() {
        this.action = null;
        this.fields = new ArrayList<UserPrefRepresentation>();
    }

    public UserPrefsRepresentation(Iterable<UserPref> prefs, String actionUrl) {
        Assertions.notNull((String)"prefs", prefs);
        Assertions.notNull((String)"actionUrl", (Object)actionUrl);
        this.action = actionUrl;
        this.fields = this.transformCollectionUserPrefsToNameStrings(prefs);
    }

    private List<UserPrefRepresentation> transformCollectionUserPrefsToNameStrings(Iterable<UserPref> userPrefs) {
        return Lists.newArrayList((Iterable)Iterables.transform(userPrefs, (Function)new Function<UserPref, UserPrefRepresentation>(){

            public UserPrefRepresentation apply(@Nullable UserPref userPref) {
                return new UserPrefRepresentation(userPref);
            }
        }));
    }

    public String getAction() {
        return this.action;
    }

    public List<UserPrefRepresentation> getFields() {
        return this.fields;
    }
}

