/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.GadgetParsingException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetSpecUriNotAllowedException;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.GadgetFactory;
import com.atlassian.gadgets.dashboard.internal.impl.GadgetImpl;
import com.atlassian.gadgets.dashboard.internal.util.HelpLinkResolver;
import com.atlassian.gadgets.dashboard.spi.GadgetStateFactory;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GadgetFactoryImpl
implements GadgetFactory {
    private final GadgetStateFactory stateFactory;
    private final GadgetSpecFactory specFactory;
    private final I18nResolver i18n;
    private final HelpLinkResolver linkResolver;
    private final HelpPathResolver helpPathResolver;

    @Autowired
    public GadgetFactoryImpl(@ComponentImport GadgetStateFactory stateFactory, @ComponentImport GadgetSpecFactory specFactory, @ComponentImport I18nResolver i18n, @ComponentImport HelpPathResolver helpPathResolver) {
        this.stateFactory = stateFactory;
        this.specFactory = specFactory;
        this.i18n = i18n;
        this.helpPathResolver = helpPathResolver;
        this.linkResolver = new HelpLinkResolver(this.helpPathResolver);
    }

    @Override
    public Gadget createGadget(String gadgetSpecUrl, GadgetRequestContext gadgetRequestContext) throws GadgetParsingException, GadgetSpecUriNotAllowedException {
        URI gadgetSpecUri;
        try {
            gadgetSpecUri = new URI(gadgetSpecUrl);
        }
        catch (URISyntaxException e) {
            throw new GadgetSpecUriNotAllowedException((Throwable)e);
        }
        return this.createGadget(this.stateFactory.createGadgetState(gadgetSpecUri), gadgetRequestContext);
    }

    @Override
    public Gadget createGadget(GadgetState state, GadgetRequestContext gadgetRequestContext) throws GadgetParsingException {
        try {
            return new GadgetImpl(state, this.specFactory.getGadgetSpec(state, gadgetRequestContext));
        }
        catch (Exception ex) {
            String exceptionMsg = ex.getMessage();
            String errorMessage = exceptionMsg != null && exceptionMsg.contains("HTTP error 403") ? this.i18n.getText("gadget.error.loading", new Serializable[]{state.getGadgetSpecUri(), this.i18n.getText("gadget.403.error", new Serializable[]{state.getGadgetSpecUri(), this.linkResolver.getLink("whitelist.external.gadget")})}) : this.i18n.getText("gadget.error.loading", new Serializable[]{state.getGadgetSpecUri(), exceptionMsg});
            if (gadgetRequestContext.isDebuggingEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                ex.printStackTrace(pw);
                StringBuilder extraDebugInfo = new StringBuilder(errorMessage);
                extraDebugInfo.append("\nGadget ID: ").append(state.getId());
                extraDebugInfo.append("\nStack trace: ").append(sw.toString());
                return new GadgetImpl(state, extraDebugInfo.toString());
            }
            return new GadgetImpl(state, errorMessage.toString());
        }
    }
}

