package com.atlassian.gadgets.plugins;

import com.atlassian.gadgets.directory.Category;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.conditions.AlwaysDisplayCondition;
import io.atlassian.fugue.Option;

import javax.annotation.Nonnull;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import java.util.Set;

/**
 * Inline dashboard item to render directly on the dashboard rather than via opensocial iframes.
 */
public interface DashboardItemModule {
    /**
     * Returns the description of this dashboard item.
     */
    Option<DirectoryDefinition> getDirectoryDefinition();

    /**
     * Return true if this dashboarditem requires configuration to be entered by the user
     */
    boolean isConfigurable();

    /**
     * @return an AMD module to call on the client side when rendering this dashboard item. May not be defined for
     * server-side dashboard items.
     */
    Option<String> getAMDModule();

    /**
     * @return Key of the WebResource associated with this gadget. It will be asynchronously downloaded before gadget is initialized.
     */
    Option<String> getWebResourceKey();

    /**
     * Renders server side content for the dashboard item.  This may not write anything if the dashboard item is to be
     * rendered entirely on the client-side.
     * <p/>
     * The context should contain user preferences stored for the dashboard item to render.
     */
    void renderContent(Writer writer, final Map<String, Object> context);

    /**
     * @return the condition, which is checks if the dashboard item should be rendered. If no condition was defined
     * in XML descriptor, this method should return {@link com.atlassian.gadgets.plugins.DashboardItemModule#ALWAYS_TRUE_CONDITION}.
     */
    @Nonnull
    Condition getCondition();

    /**
     * Specification of the dashboard item.
     */
    interface DirectoryDefinition {
        /**
         * The title of the dashboard item. Can't be null.
         */
        String getTitle();

        /**
         * The optional i18n key of the title of the dashboard item. Can't be null.
         */
        Option<String> getTitleI18nKey();

        /**
         * Author/Vendor of the dashboard item. Can't be null.
         */
        Author getAuthor();

        /**
         * Returns categories of this directory definition. Can't be null.
         */
        Set<Category> getCategories();

        /**
         * Returns an absolute URL of the thumbnail.
         */
        Option<URI> getThumbnail();
    }

    interface Author {
        /**
         * Fullname of the author. Can't be null.
         */
        String getFullname();

        Option<String> getEmail();
    }

    Condition ALWAYS_TRUE_CONDITION = new AlwaysDisplayCondition();
}
