package com.atlassian.gadgets.feed;

import java.net.URI;

/**
 * Reads a gadget feed and provides access to the feed's properties.
 *
 * @since 3.2
 */
public interface GadgetFeedReader {
    /**
     * Get the name of the application providing the feed.
     *
     * @return the name of the application providing the feed.
     */
    public String getApplicationName();

    /**
     * Get the title of the gadget feed.
     *
     * @return the title of the gadget feed
     */
    public String getTitle();

    /**
     * Get the icon of the gadget feed.
     * If the feed has no icon, null is returned.
     *
     * @return the icon of the gadget feed
     */
    public URI getIcon();

    /**
     * Get the base URI of the applications
     *
     * @return the base URI of the applications
     */
    public URI getBaseUri();

    /**
     * Determines if the provided gadget spec exists in the gadget feed.
     *
     * @param gadgetSpecUri - the URI of gadget spec to search for.
     * @return true if the provided gadget spec exists in the gadget feed.
     */
    public boolean contains(URI gadgetSpecUri);

    /**
     * Get all of the gadget spec URI available in the feed.
     *
     * @return all of the gadget spec URI available in the feed.
     */
    public Iterable<URI> entries();
}
