package com.atlassian.gadgets.feed;

import java.net.URI;

/**
 * Factory for creating {@link GadgetFeedReader}
 *
 * @since 3.2
 */
public interface GadgetFeedReaderFactory {
    /**
     * Get a feed reader for the provided URI
     *
     * @param feedUri - the URI of the feed to read
     * @return a feed reader for the provided URI
     * @throws NonAtomGadgetSpecFeedException if the feed is not in the correct format.
     * @throws GadgetFeedParsingException     if the reader is unable to correctly parse the feed.
     */
    public GadgetFeedReader getFeedReader(URI feedUri);
}
