package com.atlassian.gadgets.dashboard;

import com.atlassian.gadgets.plugins.DashboardItemModuleDescriptor;
import com.atlassian.plugin.ModuleCompleteKey;
import io.atlassian.fugue.Option;

import javax.annotation.Nonnull;

public interface DashboardItemModules {
    /**
     * Returns an optional DashboardItemModuleDescriptor for a given OpenSocial gadget URI identifier.
     * This may not be defined if no dashboard item module mapped to this URI can be found in the plugins system.
     *
     * @param uri of the specification to replace.
     */
    Option<DashboardItemModuleDescriptor> getDashboardItemModuleDescriptor(@Nonnull String uri);

    /**
     * Returns all dashboard items which declared a specification.
     */
    Iterable<DashboardItemModuleDescriptor> getDashboardItemsWithDirectoryDefinition();

    Option<DashboardItemModuleDescriptor> getDashboardItemForModuleKey(@Nonnull ModuleCompleteKey moduleCompleteKey);
}
