package com.atlassian.gadgets;

import javax.annotation.concurrent.Immutable;
import java.net.URI;

import static com.google.common.base.Preconditions.checkNotNull;

@Immutable
public class OpenSocialDashboardItemModuleId implements DashboardItemModuleId {
    private final URI id;

    public OpenSocialDashboardItemModuleId(final URI id) {
        this.id = checkNotNull(id);
    }

    @Override
    public String getId() {
        return id.toASCIIString();
    }

    public URI getSpecUri() {
        return id;
    }

    @Override
    public DashboardItemType getType() {
        return DashboardItemType.OPEN_SOCIAL_GADGET;
    }

    @Override
    public <T> T accept(final DashboardItemModuleIdVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final OpenSocialDashboardItemModuleId that = (OpenSocialDashboardItemModuleId) o;

        if (id != null ? !id.equals(that.id) : that.id != null) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
