package com.atlassian.gadgets;

import io.atlassian.fugue.Option;

public enum DashboardItemType {
    LOCAL_DASHBOARD_ITEM("dashboard-item"),
    OPEN_SOCIAL_GADGET("gadget");

    private final String name;

    DashboardItemType(final String name) {
        this.name = name;
    }

    public static Option<DashboardItemType> forName(final String name) {
        for (DashboardItemType type : values()) {
            if (type.getName().equals(name)) {
                return Option.some(type);
            }
        }
        return Option.none();
    }

    public String getName() {
        return name;
    }

    /**
     * Determines whether or not the item type is for an open social gadget or a
     * local dashboard item.
     * @return <code>true</code> if it is an open social gadget.
     */
    public boolean isOpenSocialGadget() {
        return this == OPEN_SOCIAL_GADGET;
    }
}