package com.atlassian.gadgets;

import com.atlassian.gadgets.dashboard.Color;

/**
 * <p>Representation of the dashboard item state. Dashboard item consist of:</p>
 * <p>
 * <ul>
 * <li>a {@link GadgetId}, used to uniquely identify the dashboard item within the system</li>
 * <li>a {@link Color}, used in dashboard item's chrome.</li>
 * </ul>
 * </p>
 *
 * <p>
 * Implementations of this class are required to be <b>immutable</b>.
 * </p>
 */
public interface DashboardItemState {
    GadgetId getId();

    Color getColor();

    <V> V accept(DashboardItemStateVisitor<V> visitor);
}
