/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.feature.discovery.api;

import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ProductVersion
implements Comparable<ProductVersion> {
    private static final Pattern PATTERN = Pattern.compile("^([0-9]+)\\.([0-9]+).*$");
    private final int major;
    private final int minor;

    public ProductVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public ProductVersion(@Nonnull String versionString) {
        Matcher matcher = PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("String %s is not a valid product version, it must be in format '<major>.<minor>'", versionString));
        }
        this.major = Integer.parseInt(matcher.group(1));
        this.minor = Integer.parseInt(matcher.group(2));
    }

    @Override
    public int compareTo(@Nonnull ProductVersion other) {
        return Comparator.comparing(ProductVersion::getMajor).thenComparing(ProductVersion::getMinor).compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductVersion)) {
            return false;
        }
        ProductVersion that = (ProductVersion)o;
        return this.major == that.major && this.minor == that.minor;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    public String toString() {
        return String.format("%d.%d", this.major, this.minor);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }
}

