/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extras.api;

import com.google.common.collect.ImmutableSet;

public final class Product {
    private static final String SHAREPOINT_PLUGIN_NS = "sharepoint_plugin";
    private static final String GREENHOPPER_NS = "greenhopper";
    private static final String TEAM_CALENDARS_NS = "team_calendars";
    private static final String BONFIRE_NS = "bonfire";
    private static final String VSS_PLUGIN_NS = "vss_plugin";
    public static Product JIRA = new Product("JIRA", "jira");
    public static Product CONFLUENCE = new Product("Confluence", "conf");
    public static Product BAMBOO = new Product("Bamboo", "bamboo");
    public static Product CROWD = new Product("Crowd", "crowd");
    public static Product CLOVER = new Product("Clover", "clover");
    public static Product FISHEYE = new Product("FishEye", "fisheye");
    public static Product CRUCIBLE = new Product("Crucible", "crucible");
    public static Product STASH = new Product("Stash", "stash");
    public static Product EDIT_LIVE_PLUGIN = new Product("Edit Live Plugin", "edit_live_plugin", true);
    public static Product PERFORCE_PLUGIN = new Product("Perforce Plugin", "perforce_plugin", true);
    public static Product SHAREPOINT_PLUGIN = new Product("Sharepoint Plugin", "sharepoint_plugin", true);
    public static Product GREENHOPPER = new Product("GreenHopper", "greenhopper", true);
    public static Product TEAM_CALENDARS = new Product("Team Calendars", "team_calendars", true);
    public static Product BONFIRE = new Product("Bonfire", "bonfire", true);
    public static Product VSS_PLUGIN = new Product("VSS Plugin", "vss_plugin", true);
    public static Iterable<Product> ATLASSIAN_PRODUCTS = ImmutableSet.of((Object[])new Product[]{JIRA, CONFLUENCE, BAMBOO, CROWD, CLOVER, FISHEYE, CRUCIBLE, STASH, EDIT_LIVE_PLUGIN, PERFORCE_PLUGIN, SHAREPOINT_PLUGIN, GREENHOPPER, TEAM_CALENDARS, BONFIRE, VSS_PLUGIN});
    public static Product ALL_PLUGINS = new Product("All Plugins", "plugins.*", true);
    private final String name;
    private final String namespace;
    private final boolean plugin;

    public Product(String name, String namespace) {
        this(name, namespace, false);
    }

    public Product(String name, String namespace, boolean plugin) {
        this.name = name;
        this.plugin = plugin;
        this.namespace = "com.atlassian.bonfire.plugin".equals(namespace) ? BONFIRE_NS : ("com.atlassian.confluence.extra.team-calendars".equals(namespace) ? TEAM_CALENDARS_NS : ("com.pyxis.greenhopper.jira".equals(namespace) ? GREENHOPPER_NS : ("com.atlassian.confluence.extra.sharepoint".equals(namespace) ? SHAREPOINT_PLUGIN_NS : ("com.atlassian.jira.plugin.ext.vss".equals(namespace) ? VSS_PLUGIN_NS : namespace))));
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isPlugin() {
        return this.plugin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product p = (Product)o;
        return !(this.name != null ? !this.name.equalsIgnoreCase(p.name) : p.name != null);
    }

    public int hashCode() {
        return 527 + this.name.hashCode();
    }

    public String toString() {
        return "product <" + this.getName() + ">";
    }
}

