/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extras.api;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Product {
    JIRA("JIRA", "jira"),
    CONFLUENCE("Confluence", "conf"),
    BAMBOO("Bamboo", "bamboo"),
    CROWD("Crowd", "crowd"),
    CLOVER("Clover", "clover"),
    FISHEYE("FishEye", "fisheye"),
    CRUCIBLE("Crucible", "crucible"),
    EDIT_LIVE_PLUGIN("Edit Live Plugin", "edit_live_plugin", true),
    PERFORCE_PLUGIN("Perforce Plugin", "perforce_plugin", true),
    SHAREPOINT_PLUGIN("Sharepoint Plugin", "sharepoint_plugin", true),
    GREENHOPPER("GreenHopper", "greenhopper", true),
    TEAM_CALENDARS("Team Calendars", "team_calendars", true),
    BONFIRE("Bonfire", "bonfire", true),
    VSS_PLUGIN("VSS Plugin", "vss_plugin", true);

    private final String name;
    private final String namespace;
    private final boolean plugin;

    private Product(String name, String namespace) {
        this(name, namespace, false);
    }

    private Product(String name, String namespace, boolean plugin) {
        this.name = name;
        this.namespace = namespace;
        this.plugin = plugin;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isPlugin() {
        return this.plugin;
    }

    public boolean equals(Product o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != ((Object)((Object)o)).getClass()) {
            return false;
        }
        return !(this.name != null ? !this.name.equalsIgnoreCase(o.name) : o.name != null);
    }

    public String toString() {
        return "product <" + this.getName() + ">";
    }
}

