/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extras.core;

import com.atlassian.extras.api.Contact;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.Organisation;
import com.atlassian.extras.api.Partner;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.DateEditor;
import com.atlassian.extras.common.LicenseTypeAndEditionResolver;
import com.atlassian.extras.common.log.Logger;
import com.atlassian.extras.common.util.LicenseProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProductLicense
implements ProductLicense {
    private static final Logger.Log log = Logger.getInstance(DefaultProductLicense.class);
    private static final long MILLIS_IN_A_DAY = 86400000L;
    private final String description;
    private final Product product;
    private final String serverId;
    private final Partner partner;
    private final Organisation organisation;
    private final Collection<Contact> contacts;
    private final Date creationDate;
    private final Date purchaseDate;
    private final int maximumNumberOfUsers;
    private final Date expiryDate;
    private final Date maintenanceExpiryDate;
    private final String supportEntitlementNumber;
    private final boolean evaluation;
    private final LicenseType licenseType;
    private final LicenseProperties properties;

    protected DefaultProductLicense(Product product, LicenseProperties properties) {
        log.debug("--- Creating license for " + (Object)((Object)product));
        this.description = properties.getProperty("Description");
        this.product = product;
        this.evaluation = Boolean.valueOf(properties.getProperty("Evaluation"));
        this.serverId = properties.getProperty("ServerID");
        this.partner = DefaultProductLicense.getPartner(properties);
        this.organisation = new DefaultOrganisation(properties.getProperty("Organisation"));
        this.contacts = DefaultProductLicense.getContacts(properties);
        this.creationDate = this.getCreationDate(properties);
        this.purchaseDate = this.getPurchaseDate(properties);
        this.expiryDate = this.getExpiryDate(properties);
        this.maintenanceExpiryDate = DateEditor.getDate(properties.getProperty("MaintenanceExpiryDate", "1970-01-01"));
        this.supportEntitlementNumber = properties.getProperty("SEN");
        this.maximumNumberOfUsers = properties.getInt("NumberOfUsers", 0);
        this.licenseType = LicenseTypeAndEditionResolver.getLicenseType(properties.getProperty("LicenseTypeName"));
        this.properties = properties;
        log.debug("--- Done creating license for " + (Object)((Object)product));
    }

    private Date getCreationDate(LicenseProperties properties) {
        String creationDateString = properties.getProperty("CreationDate", "1970-01-01");
        log.debug("Creation date is <" + creationDateString + ">");
        return DateEditor.getDate(creationDateString);
    }

    private Date getPurchaseDate(LicenseProperties properties) {
        String creationDateString = properties.getProperty("CreationDate", "1970-01-01");
        String purchaseDateString = properties.getProperty("PurchaseDate", creationDateString);
        log.debug("Purchase date is <" + purchaseDateString + ">");
        return DateEditor.getDate(purchaseDateString);
    }

    private Date getExpiryDate(LicenseProperties properties) {
        String expiryDateString = properties.getProperty("LicenseExpiryDate", "1970-01-01");
        log.debug("Expiry date is <" + expiryDateString + ">");
        return DateEditor.getDate(expiryDateString);
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public Partner getPartner() {
        return this.partner;
    }

    @Override
    public Organisation getOrganisation() {
        return this.organisation;
    }

    @Override
    public Collection<Contact> getContacts() {
        return this.contacts;
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.creationDate.getTime());
    }

    @Override
    public Date getPurchaseDate() {
        return new Date(this.purchaseDate.getTime());
    }

    @Override
    public Date getExpiryDate() {
        return this.expiryDate != null ? new Date(this.expiryDate.getTime()) : null;
    }

    @Override
    public int getNumberOfDaysBeforeExpiry() {
        if (this.expiryDate == null) {
            return Integer.MAX_VALUE;
        }
        return this.getDaysBeforeDate(this.expiryDate);
    }

    @Override
    public boolean isExpired() {
        return this.expiryDate != null && this.expiryDate.compareTo(new Date()) < 0;
    }

    @Override
    public Date getMaintenanceExpiryDate() {
        return this.maintenanceExpiryDate != null ? new Date(this.maintenanceExpiryDate.getTime()) : null;
    }

    @Override
    public int getNumberOfDaysBeforeMaintenanceExpiry() {
        if (this.maintenanceExpiryDate == null) {
            return Integer.MAX_VALUE;
        }
        return this.getDaysBeforeDate(this.maintenanceExpiryDate);
    }

    @Override
    public boolean isMaintenanceExpired() {
        return this.maintenanceExpiryDate != null && this.maintenanceExpiryDate.compareTo(new Date()) < 0;
    }

    @Override
    public String getSupportEntitlementNumber() {
        return this.supportEntitlementNumber;
    }

    @Override
    public int getMaximumNumberOfUsers() {
        return this.maximumNumberOfUsers;
    }

    @Override
    public boolean isUnlimitedNumberOfUsers() {
        return this.maximumNumberOfUsers == -1;
    }

    @Override
    public boolean isEvaluation() {
        return this.evaluation;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    private int getDaysBeforeDate(Date date) {
        return (int)((date.getTime() - System.currentTimeMillis()) / 86400000L);
    }

    private static Partner getPartner(LicenseProperties properties) {
        String partnerName = properties.getProperty("PartnerName");
        return partnerName != null ? new DefaultPartner(partnerName) : null;
    }

    private static Collection<Contact> getContacts(LicenseProperties properties) {
        String contactEmail = properties.getProperty("ContactEMail");
        String contactName = properties.getProperty("ContactName");
        if (contactEmail != null || contactName != null) {
            return Collections.singletonList(new DefaultContact(contactName, contactEmail));
        }
        return Collections.emptyList();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    private static final class DefaultContact
    implements Contact {
        private final String name;
        private final String email;

        DefaultContact(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }
    }

    private static final class DefaultOrganisation
    implements Organisation {
        private final String name;

        DefaultOrganisation(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static final class DefaultPartner
    implements Partner {
        private final String name;

        DefaultPartner(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

